# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import ConfigMount
import LazyMount
from CliParser import guardNotThisPlatform

upnpConfig = None
natHwCapabilities = None

def getUpnpConfig():
   return upnpConfig

def upnpSupportedGuard( mode, token ):
   # Check if any UPNP related feature is supported
   if natHwCapabilities.natUpnpPortMapSupported:
      return None
   return guardNotThisPlatform

def Plugin( entityManager ):
   global upnpConfig, natHwCapabilities

   upnpConfig = ConfigMount.mount( entityManager,
         'upnp/config', 'Upnp::Config', 'w' )

   natHwCapabilities = LazyMount.mount( entityManager,
         'ip/nat/hwCapabilities', 'Ip::Nat::HwCapabilities', 'r' )
