# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
from Intf.IntfRange import IntfRangeMatcher
from CliPlugin.IntfGroupLib import IntfGroupConfigMode
from CliPlugin.VlanIntfCli import VlanAutoIntfType

def _addIntf( mode, args ):
   mode.group().addIntf( args[ 'INTFS' ] )

def _remIntf( mode, args ):
   mode.group().remIntf( args[ 'INTFS' ] )

class VlanGroupInterfaceCmd( CliCommand.CliCommandClass ):
   syntax = 'interface INTFS'
   noOrDefaultSyntax = syntax
   data = {
      'interface': 'Configure member',
      'INTFS': IntfRangeMatcher( explicitIntfTypes={ VlanAutoIntfType } ),
   }
   handler = _addIntf
   noOrDefaultHandler = _remIntf

IntfGroupConfigMode.addCommandClass( VlanGroupInterfaceCmd )

