# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliParser
import CliCommand
import LazyMount

bridgingHwCapabilities = None

def vplsSupportedGuard( mode, token ):
   if bridgingHwCapabilities.vplsSupported:
      return None
   return CliParser.guardNotThisPlatform

vplsNodeForShow = CliCommand.guardedKeyword( 'vpls',
      helpdesc='Virtual Private LAN Service information',
      guard=vplsSupportedGuard )

def vplsShowTechGuard():
   return not vplsSupportedGuard( mode=None, token=None )

def Plugin( entityManager ):
   global bridgingHwCapabilities

   bridgingHwCapabilities = LazyMount.mount( entityManager,
                                             'bridging/hwcapabilities',
                                             'Bridging::HwCapabilities', 'r' )
