# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from BasicCli import GlobalConfigMode
from CliCommand import CliCommandClass
from CliToken.Router import routerMatcherForConfig
from CliPlugin.Vpls import vplsNodeForShow
import ConfigMount

vplsConfig = None

def getVplsConfigInstanceCollection( mode=None ):
   '''Returns an unsorted iterable of the configured instances'''
   return vplsConfig.instance

#------------------------------------------------------------------------------
# Command Class for:
#    config
#      [ no | default ] router vpls
#------------------------------------------------------------------------------
class RouterVplsCmd( CliCommandClass ):
   syntax = 'router vpls'
   noOrDefaultSyntax = syntax
   data = {
      'router': routerMatcherForConfig,
      'vpls': vplsNodeForShow,
   }
   handler = 'VplsCli.routerVplsCmdHandler'
   noOrDefaultHandler = 'VplsCli.routerVplsCmdNoHandler'

GlobalConfigMode.addCommandClass( RouterVplsCmd )

def Plugin( entityManager ):
   global vplsConfig
   vplsConfig = ConfigMount.mount( entityManager,
                                   'vpls/config',
                                   'Pseudowire::VplsConfig', 'w' )
