# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from BasicCliModes import EnableMode
from CliCommand import CliCommandClass
from CliPlugin.BridgingCli import (
   MacAddrTableExprForClear,
   matcherInterface,
)
from CliPlugin.VlanCli import vlanIdMatcher
from CliPlugin.VplsShowCli import PseudowireInterfaceNameMatcher
from CliToken.Clear import clearKwNode

# clear ( ( mac address-table ) | mac-address-table )
#       dynamic [ vlan <vlanId> ] interface <pseudowireIntf>
class ClearMacAddressTableDynamicPseudowireCmd( CliCommandClass ):
   syntax = 'clear MAC_ADDR_TABLE dynamic [ vlan VLANID ] interface INTF_NAME'
   data = {
      'clear': clearKwNode,
      'MAC_ADDR_TABLE': MacAddrTableExprForClear,
      'dynamic': 'Dynamic entries',
      'vlan': 'Per VLAN',
      'VLANID': vlanIdMatcher,
      'interface': matcherInterface,
      'INTF_NAME': PseudowireInterfaceNameMatcher(),
   }
   handler = "BridgingCliHandler.doMacAddressTableClear"

EnableMode.addCommandClass( ClearMacAddressTableDynamicPseudowireCmd )
