# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliModel

class VrfLeakId( CliModel.Model ):
   vrfs = CliModel.Dict( valueType=int,
         help='A mapping between VRF name and VRF ID' )

   def render( self ):
      for ( vrfName, vrfId ) in self.vrfs.items():
         # pylint: disable-next=consider-using-f-string
         print( '%20s : %d' % ( vrfName, vrfId ) )
