#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
# pylint: disable-next=consider-using-from-import
import CliPlugin.RouteMapCli as RouteMapCli
import CliPlugin.VrfCli as VrfCli # pylint: disable=consider-using-from-import
# pylint: disable-next=consider-using-from-import
import CliPlugin.VrfLeakCli as VrfLeakCli
from Toggles import RcfLibToggleLib
from CliPlugin import RcfCliLib

#--------------------------------------------------------------------------------
# ( no | default ) leak routes source-vrf VRFNAME subscribe-policy MAPNAME
#--------------------------------------------------------------------------------
class ConfigureVrfLeakCmd( CliCommand.CliCommandClass ):
   syntax = 'leak routes source-vrf VRFNAME '
   noOrDefaultSyntax = 'leak routes source-vrf VRFNAME ...'
   data = {
      'leak': 'Configure VRF leaking policy',
      'routes': 'Configure VRF route leaking policy',
      'source-vrf': 'Specify the VRF to leak routes from',
      'VRFNAME': VrfCli.vrfMatcher,
      'subscribe-policy': 'Route map to select leaked routes',
      'MAPNAME': RouteMapCli.mapNameMatcher,
      'subscribe': 'RCF function to select leaked routes',
      'rcf': RcfCliLib.rcfKw,
      'FUNCTION': RcfCliLib.rcfFunctionMatcher
   }
   if RcfLibToggleLib.toggleRcfLeakRoutesEnabled():
      syntax += '( ( subscribe-policy MAPNAME ) | ( subscribe rcf FUNCTION ) )'
   else:
      syntax += 'subscribe-policy MAPNAME'
   handler = VrfLeakCli.VrfLeakModelet.configureVrfLeak
   noOrDefaultHandler = VrfLeakCli.VrfLeakModelet.noVrfLeak

VrfLeakCli.VrfLeakModelet.addCommandClass( ConfigureVrfLeakCmd )
