# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliGlobal
from CliPlugin.TrafficPolicyCliLib import (
   DefaultActionsBaseContext,
   MatchRuleContext,
)
from CliPlugin.TrafficPolicyCliContext import TrafficPolicyBaseContext
from CliMode.VrfSelectionPolicyMode import (
      VrfSelectionPolicyConfigMode,
      VrfSelectionDefaultIpv4ActionConfigMode,
      VrfSelectionDefaultIpv6ActionConfigMode,
      VrfSelectionMatchIpv4RuleConfigMode,
      VrfSelectionMatchIpv6RuleConfigMode,
      VrfSelectionActionRuleConfigMode )
import ConfigMount
import LazyMount
import Tac
from TypeFuture import TacLazyType

tacMatchOption = TacLazyType( 'PolicyMap::ClassMapMatchOption' )
matchIpAccessGroup = tacMatchOption.matchIpAccessGroup
matchIpv6AccessGroup = tacMatchOption.matchIpv6AccessGroup

vrfSelPolicyConfig = None
vrfSelPolicyStatus = None
vrfSelPolicyStatusReqDir = None
vrfSelPolicyIntfConfig = None
allIntfStatusDir = None
vrfSelPolicyFallbackConfig = None
vrfSelPolicyHwCapabilities = None
vrfSelPolicyFieldSetConfig = None
vrfSelPolicyHwRouteStatus = None
gv = CliGlobal.CliGlobal( dict( fieldSetConfig=None,
                                fieldSetConfigDir=None,
                                fieldSetMergeSm=None ) )

UniqueId = TacLazyType( "Ark::UniqueId" )
ActionType = TacLazyType( "PolicyMap::ActionType" )
ReservedClassMapNames = TacLazyType( 'TrafficPolicy::ReservedClassMapNames' )

class VrfSelPolicyContext( TrafficPolicyBaseContext ):
   pmapType = 'mapTrafficPolicy'

   def childMode( self ):
      return VrfSelectionPolicyConfigMode

   def mapTypeStr( self ):
      return "vrf-selection-policy"

class VrfSelPolicyMatchRuleContext( MatchRuleContext ):
   def childMode( self, matchRuleName, matchOption ):
      if matchOption == matchIpAccessGroup:
         return VrfSelectionMatchIpv4RuleConfigMode
      elif matchOption == matchIpv6AccessGroup:
         return VrfSelectionMatchIpv6RuleConfigMode
      assert False, 'unknown matchOption ' + matchOption
      return None

   def actionMode( self ):
      return VrfSelectionActionRuleConfigMode

   def setAction( self, actionType, actionValue=None, no=False, clearActions=None ):
      if no:
         self.matchRuleAction.delAction( actionType )
      else:
         if clearActions:
            for action in clearActions:
               self.matchRuleAction.delAction( action )
         actionsConfig = self.trafficPolicyContext.config().actions
         if actionType == ActionType.setVrf:
            action = actionsConfig.setVrfAction.newMember( self.ruleName,
                                                           UniqueId(),
                                                           actionValue )
            self.matchRuleAction.addAction( actionType, action )
         elif actionType == ActionType.setDecapVrf:
            action = actionsConfig.setDecapVrfAction.newMember( self.ruleName,
                                                                UniqueId(),
                                                                actionValue[ 0 ],
                                                                actionValue[ 1 ],
                                                                actionValue[ 2 ] )
            self.matchRuleAction.addAction( actionType, action )
         else:
            assert False, 'unknown action ' + actionType

class VrfSelPolicyDefaultActionsContext( DefaultActionsBaseContext ):
   def childMode( self ):
      if self.matchOption == matchIpAccessGroup:
         return VrfSelectionDefaultIpv4ActionConfigMode
      elif self.matchOption == matchIpv6AccessGroup:
         return VrfSelectionDefaultIpv6ActionConfigMode
      assert False, 'unknown matchOption ' + self.matchOption
      return None

   def setAction( self, actionType, actionValue=None, no=False, clearActions=None ):
      if no:
         self.delAction( actionType )
      else:
         if clearActions:
            for action in clearActions:
               self.delAction( action )
         actionsConfig = self.trafficPolicyContext.config().actions
         # These actions are not tied to specific rules.
         ruleName = ""
         if actionType == ActionType.setVrf:
            action = actionsConfig.setVrfAction.newMember( ruleName,
                                                           UniqueId(),
                                                           actionValue )
         elif actionType == ActionType.setVrfSecondary:
            action = actionsConfig.setVrfSecondaryAction.newMember(
                  ruleName, UniqueId(), actionValue )
         elif actionType == ActionType.setDecapVrf:
            action = actionsConfig.setDecapVrfAction.newMember( ruleName,
                                                                UniqueId(),
                                                                actionValue[ 0 ],
                                                                actionValue[ 1 ],
                                                                actionValue[ 2 ] )
         else:
            assert False, 'unknown action ' + actionType
         self.addAction( actionType, action )

def startFieldSetConfigMergeSm():
   mergedFieldSetConfig = Tac.newInstance( 'Classification::FieldSetConfig',
                                           'mergedConfig' )
   gv.fieldSetMergeSm = Tac.newInstance( 'Classification::FieldSetConfigMergeSm',
                                         gv.fieldSetConfigDir, mergedFieldSetConfig )
   gv.fieldSetConfig = mergedFieldSetConfig

def Plugin( entityManager ):
   global vrfSelPolicyConfig
   global vrfSelPolicyStatus
   global vrfSelPolicyStatusReqDir
   global allIntfStatusDir
   global vrfSelPolicyIntfConfig
   global vrfSelPolicyFallbackConfig
   global vrfSelPolicyHwCapabilities
   global vrfSelPolicyFieldSetConfig
   global vrfSelPolicyHwRouteStatus
   mountGroup = entityManager.mountGroup()
   vrfSelPolicyStatus = mountGroup.mount( 'vrfSelectionPolicy/status',
                                          'Tac::Dir', 'ri' )
   callback = None
   gv.fieldSetConfigDir = mountGroup.mount( "vrfSelectionPolicy/fieldset/input/",
                                            "Tac::Dir", "ri" )
   callback = startFieldSetConfigMergeSm
   mountGroup.close( callback=callback, blocking=False )
   vrfSelPolicyConfig = ConfigMount.mount( entityManager,
                                    'vrfSelectionPolicy/config',
                                    'VrfSelectionPolicy::VrfSelectionPolicyConfig',
                                    'wi' )
   vrfSelPolicyIntfConfig = ConfigMount.mount( entityManager,
                                               'vrfSelectionPolicy/intf/config',
                                               'PolicyMap::IntfConfig', 'w' )
   vrfSelPolicyFallbackConfig = ConfigMount.mount( entityManager,
                                       'vrfSelectionPolicy/fallbackVrf',
                                       'VrfSelectionPolicy::VrfSelectionFallbackVrf',
                                       'w' )
   vrfSelPolicyStatusReqDir = LazyMount.mount( entityManager,
                                            'vrfSelectionPolicy/statusRequest/cli',
                                            'PolicyMap::PolicyMapStatusRequestDir',
                                            'wc' )
   vrfSelPolicyHwCapabilities = LazyMount.mount( entityManager,
                                             'vrfSelectionPolicy/hwcapabilities',
                                             'VrfSelectionPolicy::HwCapabilities',
                                             'r' )
   allIntfStatusDir = LazyMount.mount( entityManager, 'interface/status/all',
                                       'Interface::AllIntfStatusDir', 'r' )
   # Writable mount for CLI plugin.
   vrfSelPolicyFieldSetConfig = LazyMount.mount( entityManager,
                                           'vrfSelectionPolicy/fieldset/input/cli',
                                           'Classification::FieldSetConfig', 'w' )

   vrfSelPolicyHwRouteStatus = LazyMount.mount( entityManager,
                                                'routing/hardware/route/status',
                                                'Routing::Hardware::RouteStatus',
                                                'r' )
