# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import CliCommand
from CliPlugin import VxlanCli
import Toggles.GmpToggleLib

snoopingKw = CliCommand.guardedKeyword(
   "snooping",
   "Enable IGMP snooping over VXLAN",
   guard=VxlanCli.vxlanIgmpSnoopingSupportedGuard )

class VxlanIgmpSnoopingCmd( CliCommand.CliCommandClass ):
   syntax = 'igmp snooping'
   noOrDefaultSyntax = syntax
   data = {
      'igmp': "Configure IGMP protocol",
      'snooping': snoopingKw,
   }
   handler = "VxlanIgmpSnoopingConfigHandler.enableSnooping"
   noOrDefaultHandler = "VxlanIgmpSnoopingConfigHandler.disableSnooping"

if Toggles.GmpToggleLib.toggleVxlanIgmpSnoopingEnabled():
   VxlanCli.VxlanIntfModelet.addCommandClass( VxlanIgmpSnoopingCmd )
