# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os
import sys

import BasicCli
import CliCommand
import CliMatcher
import Tac

tokenInterval = CliMatcher.IntegerMatcher( 1, 9999,
                                         helpdesc="Interval to repeat (default 2s)" )
watchCommand = CliMatcher.StringMatcher( helpname="COMMAND",
                                         helpdesc="Command to repeat" )

class WatchCmd( CliCommand.CliCommandClass ):
   syntax = """watch [<interval>] [diff] <cmd>"""
   data = { 'watch': 'Execute a command repeatedly',
            '<interval>': tokenInterval,
            'diff': 'Highlight differences',
            '<cmd>': watchCommand }

   @staticmethod
   def handler( mode, args ):
      interval = args.get( '<interval>', 2 )
      cmd = [ 'watch', '-x', '-n', str( interval ) ]
      if 'diff' in args:
         cmd.append( '-d' )
      cmd += [ sys.executable, '/usr/bin/CliShell', '-s', mode.session_.sysname,
               '-p', str( mode.session_.privLevel_ ) ]
      if mode.session_.disableAaa_:
         cmd += [ '-A' ]
      cmd += [ '-c', args[ '<cmd>' ] ]
      Tac.run( cmd, stdin=sys.stdin, stdout=sys.stdout, stderr=sys.stderr,
               env=os.environ, ignoreReturnCode=True )

BasicCli.ExecMode.addCommandClass( WatchCmd )
