# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

import BasicCli
import CliCommand
import CliMatcher
import CliModel
import CliToken.Hardware
import ConfigMount
# import LazyMount
import ShowCommand
from CliPlugin import TechSupportCli

watchdogConfig = None
# watchdogStatus = None

matcherSystemController = CliMatcher.KeywordMatcher( 'system-controller',
      helpdesc='System Management' )
matcherWatchdog = CliMatcher.KeywordMatcher( 'watchdog',
      helpdesc='Watchdog configuration' )

#--------------------------------------------------------------------------------
# show hardware system-controller watchdog
#--------------------------------------------------------------------------------
class WatchdogStatus( CliModel.Model ):
   __public__ = False

   enabled = CliModel.Bool( help="Watchdog enabled status" )

   # name = CliModel.Str( help="Driver name" )
   # timeout = CliModel.Int( help="Total time before watchdog triggers reset" )
   # lastPunchTime = CliModel.Float( help="Last time watchdog was punched" )

   def render( self ):
      status = "enabled" if self.enabled else "disabled"
      # print "Driver name:", self.name
      print( "Status:", status )
      # print "Timeout:", self.timeout
      # print "Last punched time:", self.lastPunchTime

class ShowWatchdogCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show hardware system-controller watchdog'
   data = {
      'hardware': CliToken.Hardware.hardwareMatcherForShow,
      'system-controller': matcherSystemController,
      'watchdog': matcherWatchdog,
   }

   cliModel = WatchdogStatus
   privileged = True

   @staticmethod
   def handler( mode, args ):
      # timeout = watchdogStatus.timeoutKill + watchdogStatus.timeoutPhys
      enabled = False
      try:
         pid = int( Tac.run( [ 'cat', '/var/run/watchdogd.pid' ],
                             stdout=Tac.CAPTURE,
                             stderr=Tac.DISCARD,
                             asRoot=True ) )
         Tac.run( [ 'kill', '-0', str( pid ) ], asRoot=True )
         enabled = True
      except Tac.SystemCommandError:
         pass
      except ValueError:
         pass

      # return WatchdogStatus( name=watchdogStatus.driverName,
      #                            enabled=enabled )
      #                            timeout=timeout,
      #                            lastPunchTime=watchdogStatus.lastPunchTime)

      return WatchdogStatus( enabled=enabled )

BasicCli.addShowCommandClass( ShowWatchdogCmd )

#--------------------------------------------------------------------------------
# [ no | default ] hardware system-controller watchdog
#--------------------------------------------------------------------------------
def disableWatchdog( mode, args ):
   watchdogConfig.enabled = False
   try:
      Tac.run( [ '/usr/bin/systemctl', 'stop', 'watchdog' ], asRoot=True )
   except Tac.SystemCommandError:
      pass

def enableWatchdog( mode, args ):
   watchdogConfig.enabled = True
   try:
      Tac.run( [ '/usr/bin/systemctl', 'restart', 'watchdog' ], asRoot=True )
   except Tac.SystemCommandError:
      pass

class WatchdogCmd( CliCommand.CliCommandClass ):
   syntax = 'hardware system-controller watchdog'
   noOrDefaultSyntax = 'hardware system-controller watchdog ...'
   data = {
      'hardware': CliToken.Hardware.hardwareMatcherForConfig,
      'system-controller': matcherSystemController,
      'watchdog': matcherWatchdog,
   }

   handler = enableWatchdog
   noHandler = disableWatchdog
   defaultHandler = handler

# Avoid FruCli.registerModularSystemCallback and FruCli.registerFixedSystemCallback
# since these take effect after the startup-config has been processed.
BasicCli.GlobalConfigMode.addCommandClass( WatchdogCmd )

# Timestamps are made up to maintain historical order within show tech-support
TechSupportCli.registerShowTechSupportCmd(
   '2017-08-11 09:27:00',
   cmds=[ 'show hardware system-controller watchdog' ] )

#-------------------------------------------------------------------------------
# Plugin
#-------------------------------------------------------------------------------
def Plugin( entityManager ):
   global watchdogConfig
   # global watchdogStatus
   # watchdogStatus = LazyMount.mount( entityManager,
   #    'hardware/watchdog/status', 'Watchdog::Status', 'r' )
   watchdogConfig = ConfigMount.mount( entityManager,
      'hardware/watchdog/config', 'Watchdog::Config', 'w' )
