# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import LazyMount
import SharedMem
import Smash
import Tac

entityManager = None
smashEntityManager = None
writerConfigDir = None

def _getCurrentCounterPath( writerMountName ):
   return "counters/wredDrop/" + writerMountName + "/current"

def _getClearCounterPath( writerMountName ):
   return "counters/wredDrop/" + writerMountName + "/lastClear"

def _mountCounters():
   wredCounters = {}
   wredClearCounters = {}
   mountInfo = Smash.mountInfo( 'reader' )
   for name in writerConfigDir:
      if name in wredCounters:
         continue
      entry = writerConfigDir[ name ]
      wredCounters[ name ] = smashEntityManager.doMount(
         _getCurrentCounterPath( entry.writerMountName ),
         "Qos::AllIntfWredQueueCounters", mountInfo )
      wredClearCounters[ name ] = smashEntityManager.doMount(
         _getClearCounterPath( entry.writerMountName ),
         "Qos::AllIntfWredQueueCounters", mountInfo )
   return ( wredCounters, wredClearCounters )

def getCounterAccessor():
   counterAccessor = Tac.newInstance( 'Qos::WredCounterAccessor' )
   wredCounters, wredClearCounters = _mountCounters()

   for key, data in wredCounters.items():
      counterAccessor.mountPathToWredQueueCounter[ key + '/current' ] = data
   for key, data in wredClearCounters.items():
      counterAccessor.mountPathToWredQueueCounter[ key + '/lastClear' ] = data

   for writerConfig in writerConfigDir.values():
      writerConfigMetaData = Tac.Value( 'Interface::QueueCounter::MetaData',
                                        writerConfig.numUnicastQueues,
                                        writerConfig.numMulticastQueues,
                                        writerConfig.writerMountName )
      for intf in writerConfig.intf:
         counterAccessor.intfMetaData[ intf ] = writerConfigMetaData
   return counterAccessor

def Plugin( em ):
   global writerConfigDir, entityManager, smashEntityManager
   entityManager = em
   smashEntityManager = SharedMem.entityManager( sysdbEm=em )
   writerConfigDir = LazyMount.mount(
         entityManager, 'qos/hardware/wredDropCounter/', 'Tac::Dir', 'ri' )
