# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import ShowCommand
import BasicCli
from CliPlugin.IntfCli import Intf
from CliPlugin.EthIntfCli import xcvrShowKw

# --------------------------------------------------------------------------------
#
# "show transceiver error [ interface <INTFS> ]"
#
# --------------------------------------------------------------------------------

class TransceiverErrorCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show transceiver error [ interface INTFS ]'
   data = {
      'transceiver': xcvrShowKw,
      'error': 'Show transceiver errors and timing violations',
      'interface': 'Show transceiver errors for a specific interface',
      'INTFS': Intf.rangeMatcher,
   }
   handler = "XcvrErrorCliHandler.transceiverErrorCmdHandler"
   cliModel = "XcvrErrorModel.TransceiverErrorInterfaces"

BasicCli.addShowCommandClass( TransceiverErrorCmd )
