# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
import CliMatcher
import Intf.IntfRange

import Toggles.XcvrToggleLib
import IntfRangePlugin.XcvrSlot

from CliPlugin import EthIntfCli

reinitKw = CliMatcher.KeywordMatcher( 'reinitialize',
              helpdesc='Perform transceiver reinitialization' )

xcvrReinitializeSlotType = IntfRangePlugin.XcvrSlot.XcvrSlot(
   'slot', 'Hardware transceiver slot' )
slotRangeMatcher = Intf.IntfRange.IntfRangeMatcher(
   explicitIntfTypes=( xcvrReinitializeSlotType, ) )

# ---------------------------------------------------------------
# transceiver reinitialize slot <SLOTID>
# ---------------------------------------------------------------

class XcvrReinitialize( CliCommand.CliCommandClass ):
   syntax = "transceiver reinitialize SLOT"
   data = {
      "transceiver": EthIntfCli.xcvrKw,
      "reinitialize": reinitKw,
      "SLOT": slotRangeMatcher
   }
   handler = "XcvrReinitCliHandler.xcvrReinitializeHandler"

if Toggles.XcvrToggleLib.toggleXcvrReinitCliEnabled():
   BasicCli.EnableMode.addCommandClass( XcvrReinitialize )
