# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
from CliPlugin.XcvrConfigCli import XcvrConfigModelet
from CliPlugin.XcvrConfigCli import nodeTransceiver
from CliPlugin.XcvrConfigCli import diagKeyword

# --------------------------------------------------------------------------------
# [ no | default ] transceiver diag simulate removed
# --------------------------------------------------------------------------------
class TransceiverDiagSimulateRemovedCmd( CliCommand.CliCommandClass ):
   syntax = 'transceiver diag simulate removed'
   noOrDefaultSyntax = syntax
   data = {
      'transceiver': nodeTransceiver,
      'diag': diagKeyword,
      'simulate': 'Set simulated configuration',
      'removed': 'Remove transceiver',
   }

   handler = ( "XcvrSimulateRemoveCliHandler."
      "TransceiverDiagSimulateRemovedCmdHandler" )
   noOrDefaultHandler = handler

XcvrConfigModelet.addCommandClass( TransceiverDiagSimulateRemovedCmd )
