# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, CliSave

CliSave.GlobalConfigMode.addCommandSequence( 'AleCapacity.capacity' )

@CliSave.saver( 'AleCapacity::TableThreshold', 'hardware/capacity/config',
                requireMounts=( 'hardware/capacity/status', ) )
def saveCapacityThreshold( config, root, requireMounts, options ):
   saveAll = options.saveAll
   cmds = root[ 'AleCapacity.capacity' ]

   statusDir = requireMounts[ 'hardware/capacity/status' ]

   cmdStr = "hardware capacity alert table "

   for name in sorted( config.threshold ):
      rowName = name.split( '-', 1 )
      if len( rowName ) == 1:
         if config.threshold[ name ].threshold == 0:
            cmds.addCommand( "no " + cmdStr + rowName[ 0 ] )
         else:
            if config.threshold[ name ].threshold == config.threshold[ name ].clear:
               cmds.addCommand( cmdStr + rowName[ 0 ] + 
                     " threshold " + str( config.threshold[ name ].threshold ) )
            else:
               cmds.addCommand( cmdStr + rowName[ 0 ] +
                     " threshold " + str( config.threshold[ name ].threshold ) + 
                     " clear " + str( config.threshold[ name ].clear ) )
      else:
         if config.threshold[ name ].threshold == 0:
            cmds.addCommand( "no " + cmdStr + rowName[ 0 ] + " feature " +
                  rowName[ 1 ] )
         else:
            if config.threshold[ name ].implicit:
               # implies:
               # config.threshold[ name ].threshold == config.threshold[ name ].clear
               cmds.addCommand( cmdStr + rowName[ 0 ] + " feature " + rowName[ 1 ] +
                     " threshold " + str( config.threshold[ name ].threshold ) )
            else:
               cmds.addCommand( cmdStr + rowName[ 0 ] + " feature " + rowName[ 1 ] +
                     " threshold " + str( config.threshold[ name ].threshold ) + 
                     " clear " + str( config.threshold[ name ].clear ) )

   if saveAll: # pylint: disable=too-many-nested-blocks
      for agentName in sorted( statusDir ):
         # pylint: disable-next=singleton-comparison
         if statusDir[ agentName ].tableList == None:
            continue
         featureMapping = statusDir[ agentName ].tableList.featureMapping
         for tableName in sorted( featureMapping ):
            for featureName in sorted( featureMapping[ tableName ].feature ):
               rowName = tableName
               if featureName != '':
                  rowName = '-'.join( [ tableName, featureName ] )

               if rowName not in config.threshold:
                  if featureName == '':
                     cmds.addCommand( "default " + cmdStr + tableName )
                  else:
                     cmds.addCommand( "default " + cmdStr + tableName + " feature " +
                           featureName )
