#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliSavePlugin.AleCountersCliSave import (
   MonitorCounterConfigMode,
   MonitorCounterEthernetConfigMode
)
import CliSave

@CliSave.saver(
   'Ale::Counters::RateWatermarkCliConfig',
   'counter/global/rateWatermarkConfig'
)
def saveRateWatermarkConfig( config, root, requireMounts, options ):
   monMode = root[ MonitorCounterConfigMode ].getSingletonInstance()
   mode = monMode[ MonitorCounterEthernetConfigMode ].getSingletonInstance()
   cmds = mode[ 'AleCounters.intfconfig' ]
   if config.windowSize == 0:
      return
   windowSize = int( config.windowSize * 1000 )
   cmds.addCommand( f'rate watermark window {windowSize} milliseconds' )
