#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from TypeFuture import TacLazyType

CpuFabricConfig = TacLazyType( "Ale::CpuFabricConfig" )

CliSave.GlobalConfigMode.addCommandSequence( 'CpuFabric.config' )
@CliSave.saver( 'Ale::CpuFabricConfig', 'hardware/ale/cpufabric/config' )
def saveHardwareAleCpuFabricConfig( entity, root, requireMounts, options ):
   cmds = root[ 'CpuFabric.config' ]
   cmdStr = "hardware cpu forwarding monitor"
   if entity.disableHealthMonitoring:
      cmds.addCommand( "no " + cmdStr )
   elif options.saveAll:
      cmds.addCommand( cmdStr )

   numErrors = entity.numErrorsToPoweroff
   cmdStr = "hardware cpu forwarding monitor threshold shutdown " + str( numErrors )
   if numErrors != CpuFabricConfig.defaultNumErrorsToPoweroff:
      cmds.addCommand( cmdStr )
   elif options.saveAll:
      cmds.addCommand( cmdStr )

   cmdStr = "hardware cpu forwarding monitor action none"
   if entity.disableHealthRecoveryAction:
      cmds.addCommand( cmdStr )
   elif options.saveAll:
      cmds.addCommand( "no " + cmdStr )
