# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tracing
import CliSave
from CliMode.MplsEvpnMode import MplsEvpnMode

t0 = Tracing.trace0

class MplsEvpnConfigMode( MplsEvpnMode, CliSave.Mode ):
   def __init__( self, param ):
      MplsEvpnMode.__init__( self )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( MplsEvpnConfigMode )
MplsEvpnConfigMode.addCommandSequence( 'Ale.evpnMplsConfig' )

def addCommandsToMplsEvpnMode( entity, root, cmds ):
   if cmds:
      mode = root[ MplsEvpnConfigMode ].getOrCreateModeInstance( entity.name )
      mplsEvpnMode = mode[ 'Ale.evpnMplsConfig' ]
      for cmd in cmds:
         mplsEvpnMode.addCommand( cmd )

@CliSave.saver( 'Evpn::MplsConfig', 'evpn/mplsConfig' )
def saveEvpnMplsCliConfig( entity, root, requireMounts, options ):
   cmds = [ ]
   saveAll = options.saveAll
   saveAllDetail = options.saveAllDetail
   saveDefault = saveAllDetail or saveAll
   if not entity.controlWordEnabled:
      cmds.append( 'no label-stack control-word' )
   elif saveDefault:
      cmds.append( 'label-stack control-word' )

   if not entity.vlanServiceDot1qEnabled:
      cmds.append( 'vlan service dot1q remove outer' )
   elif saveDefault:
      cmds.append( 'no vlan service dot1q remove outer' )

   if entity.entropyLabelEnabled:
      cmds.append( 'label-stack entropy-label' )
   elif saveAll:
      cmds.append( 'no label-stack entropy-label' )
   addCommandsToMplsEvpnMode( entity, root, cmds )
