# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from TypeFuture import TacLazyType
import CliSave

SelectiveTraceDomain = TacLazyType( 'Ale::SelectiveTraceDomain' )

CliSave.GlobalConfigMode.addCommandSequence( 'AleL3Unicast.global' )

@CliSave.saver( 'Ale::DebugCliConfig', 'hardware/ale/l3/debugcliconfig' )
def saveDebugCliConfig( entity, root, requireMounts, options ):
   cmds = root[ 'AleL3Unicast.global' ]

   prefixCmd = 'ip hardware ale trace select prefix PREFIX'
   l2AdjCmd = 'ip hardware ale trace select l2-adj ADJ_INDEX'
   l3AdjCmd = 'ip hardware ale trace select adj FECID'
   traceSpecPrefixCmd = 'ip hardware ale trace select prefix tracespec TRACESPEC'
   traceSpecL2AdjCmd = 'ip hardware ale trace select l2-adj tracespec TRACESPEC'
   traceSpecL3AdjCmd = 'ip hardware ale trace select adj tracespec TRACESPEC'

   saveAll = options.saveAllDetail or options.saveAll

   if not entity.selectedPrefix:
      if saveAll:
         cmds.addCommand( 'no ' + prefixCmd.replace( ' PREFIX', '' ) )
   else:
      for prefix in sorted( entity.selectedPrefix ):
         cmds.addCommand( prefixCmd.replace( 'PREFIX', prefix.stringValue ) )

   if not entity.selectedL2Adj:
      if saveAll:
         cmds.addCommand( 'no ' + l2AdjCmd.replace( ' ADJ_INDEX', '' ) )
   else:
      for adj in sorted( entity.selectedL2Adj ):
         cmds.addCommand( l2AdjCmd.replace( 'ADJ_INDEX', str( adj ) ) )

   if not entity.selectedL3Adj:
      if saveAll:
         cmds.addCommand( 'no ' + l3AdjCmd.replace( ' FECID', '' ) )
   else:
      for fec in sorted( entity.selectedL3Adj ):
         cmds.addCommand( l3AdjCmd.replace( 'FECID', str( fec ) ) )

   if SelectiveTraceDomain.prefixDomain not in entity.traceSpec:
      if saveAll:
         cmds.addCommand( 'no ' + traceSpecPrefixCmd.replace( ' TRACESPEC', '' ) )
   else:
      cmds.addCommand( traceSpecPrefixCmd.replace( 'TRACESPEC',
         entity.traceSpec[ SelectiveTraceDomain.prefixDomain ] ) )

   if SelectiveTraceDomain.l2AdjDomain not in entity.traceSpec:
      if saveAll:
         cmds.addCommand( 'no ' + traceSpecL2AdjCmd.replace( ' TRACESPEC', '' ) )
   else:
      cmds.addCommand( traceSpecL2AdjCmd.replace( 'TRACESPEC',
         entity.traceSpec[ SelectiveTraceDomain.l2AdjDomain ] ) )

   if SelectiveTraceDomain.l3AdjDomain not in entity.traceSpec:
      if saveAll:
         cmds.addCommand( 'no ' + traceSpecL3AdjCmd.replace( ' TRACESPEC', '' ) )
   else:
      cmds.addCommand( traceSpecL3AdjCmd.replace( 'TRACESPEC',
         entity.traceSpec[ SelectiveTraceDomain.l3AdjDomain ] ) )
