# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string

import CliSave, Vlan
from CliSavePlugin.IntfCliSave import IntfConfigMode

IntfConfigMode.addCommandSequence( 'ArpInspection.intf' )
CliSave.GlobalConfigMode.addCommandSequence( 'ArpInspection.config' )

@CliSave.saver( 'ArpInsp::Config', 'security/arpInspection/config' )

def saveArpInspectionConfig( entity, root, requireMounts, options ):
   cmds = root[ 'ArpInspection.config' ]

   vlanList = []
   for vlanId in entity.arpInspEnabled:
      vlanList.append( vlanId )
   if vlanList:
      vlanStr = Vlan.vlanSetToCanonicalString( vlanList )
      cmds.addCommand( 'ip arp inspection vlan %s' % vlanStr )

   intfConfigs = entity.arpInspIntfConfig
   for intfId in intfConfigs:
      intfConfig = intfConfigs[ intfId ]
      saveArpInspectionIntf( intfConfig, root, options )

def saveArpInspectionIntf( entity, root, options ):
   mode = root[ IntfConfigMode ].getOrCreateModeInstance( entity.intfId )
   cmds = mode[ 'ArpInspection.intf' ]

   if entity.trust:
      cmds.addCommand( 'ip arp inspection trust' )
   elif options.saveAll:
      cmds.addCommand( 'no ip arp inspection trust' )

   if ( entity.burstIntervalLogging != entity.burstIntervalDefault ) \
         or options.saveAll:
      if entity.rateLimitLogging != 0:
         cmds.addCommand( 'ip arp inspection logging rate %d burst interval %d'
                           % ( entity.rateLimitLogging, 
                               entity.burstIntervalLogging ) )
      else:
         cmds.addCommand( 'ip arp inspection logging none ' )
   else:
      rateLimitLoggingDefault = 0 if entity.trust \
                                  else entity.rateLimitLoggingDefault
      if entity.rateLimitLogging != rateLimitLoggingDefault:
         if entity.rateLimitLogging != 0:
            cmds.addCommand( 'ip arp inspection logging rate %d'
                             % entity.rateLimitLogging )
         else:
            cmds.addCommand( 'ip arp inspection logging none' )

   if ( entity.burstIntervalErrdisable != entity.burstIntervalDefault ) \
         or options.saveAll:
      if entity.rateLimitErrdisable != 0:
         cmds.addCommand( 'ip arp inspection limit rate %d burst interval %d'
                           % ( entity.rateLimitErrdisable, 
                               entity.burstIntervalErrdisable ) )
      else:
         cmds.addCommand( 'ip arp inspection limit none' )
   else:
      rateLimitErrdisableDefault = 0 if entity.trust \
            else entity.rateLimitErrdisableDefault
      if entity.rateLimitErrdisable != rateLimitErrdisableDefault:
         if entity.rateLimitErrdisable != 0:
            cmds.addCommand( 'ip arp inspection limit rate %d'
                             % entity.rateLimitErrdisable )
         else:
            cmds.addCommand( 'ip arp inspection limit none' )


CliSave.GlobalConfigMode.addCommandSequence( 'IpMacBinding.config' )

@CliSave.saver( 'IpMacBinding::IpMacBindingDir', 'security/ipMacBinding' )
def saveIpMacBindingCliConfig( entity, root, requireMounts, options ):
   cmds = root[ 'IpMacBinding.config' ]
   for intf, bindingList in entity.ipMacBinding.items():
      for key in bindingList.bindingEntry:
         cmds.addCommand( 'ip source binding %s %s vlan %d interface %s' \
                             % ( key.ip, key.mac, key.vlan, intf) )
