#!/usr/bin/env python3
# Copyright (c) 2008, 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string

#-------------------------------------------------------------------------------
# This module implements saving the 'switchport backup-link' command.
# legacy syntax: 'switchport backup interface'
#-------------------------------------------------------------------------------
import CliSave, Vlan
from CliSavePlugin.IntfCliSave import IntfConfigMode

IntfConfigMode.addCommandSequence( 'Stp.switchport', after=[ 'Ebra.switchport' ] )

@CliSave.saver( 'Stp::BackupIntfConfig', 'stp/input/config/cli' )
def saveSwitchBackupIntfConfig( entity, root, requireMounts, options ):
   mode = root[ IntfConfigMode ].getOrCreateModeInstance( entity.name )
   cmds = mode[ 'Stp.switchport' ]
   saveAll = options.saveAll

   vlanStr = Vlan.vlanSetToCanonicalString( list( entity.backupPreferredVlans ) )
   cmd = 'switchport backup-link %s' % entity.backupIntfName

   if vlanStr:
      cmd += ' prefer vlan %s' % vlanStr

   cmds.addCommand( cmd )   
   if entity.preemptionDelay != entity.defaultPreemptionDelay or saveAll:
      cmd = 'switchport backup preemption-delay %d' % \
          entity.preemptionDelay
      cmds.addCommand( cmd )
   if entity.macMoveBurst != entity.defaultMacMoveBurst or saveAll:
      cmd = 'switchport backup mac-move-burst %d' % \
          entity.macMoveBurst
      cmds.addCommand( cmd )
   if entity.interMacMoveBurstDelay != \
          entity.defaultInterMacMoveBurstDelay or saveAll:
      cmd = 'switchport backup mac-move-burst-interval %d' % \
          entity.interMacMoveBurstDelay
      cmds.addCommand( cmd )
   if entity.initialMacMoveDelay != entity.defaultInitialMacMoveDelay or saveAll:
      cmd = 'switchport backup initial-mac-move-delay %d' % \
          entity.initialMacMoveDelay
      cmds.addCommand( cmd )
   if entity.dstMacAddress != entity.defaultDstMacAddress or saveAll:
      cmd = 'switchport backup dest-macaddr %s' % \
          entity.dstMacAddress
      cmds.addCommand( cmd )
