# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import Tac
from CliMode.BessDpi import BessDpiModeBase

class BessDpiEngineSaveMode( BessDpiModeBase, CliSave.Mode ):
   def __init__( self, param ):
      BessDpiModeBase.__init__( self )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

def registerAllCommands():
   CliSave.GlobalConfigMode.addChildMode( BessDpiEngineSaveMode )
   BessDpiEngineSaveMode.addCommandSequence( 'dpi' )

registerAllCommands()

@CliSave.saver( 'Sfe::BessDpiConfig', 'bess/cli/dpi' )
def saveConfig( entity, root, requireMounts, options ):
   mode = root[ BessDpiEngineSaveMode ].getOrCreateModeInstance( entity )
   cmds = mode[ 'dpi' ]

   if not entity.basicDpi:
      cmds.addCommand( 'no basic-dpi' )
   elif options.saveAll:
      cmds.addCommand( 'basic-dpi' )

   if entity.fastCase:
      cmds.addCommand( 'fastcase' )
   elif options.saveAll:
      cmds.addCommand( 'no fastcase' )

   if entity.classificationCache == 0:
      cmds.addCommand( 'no classification cache' )
   elif entity.classificationCache == 2:
      cmds.addCommand( 'classification cache performance' )
   elif options.saveAll:
      cmds.addCommand( 'classification cache standard' )

   if entity.offloadDeclassification:
      cmds.addCommand( 'offload declassification' )
   elif options.saveAll:
      cmds.addCommand( 'no offload declassification' )
