#!/usr/bin/env python3
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Cell
import CliSave
from CliSavePlugin.MrouteCliSave import RouterMulticastAfConfigMode
from CliSavePlugin.MrouteCliSave import getCmdRoot, getCliSaveVersion
from McastCommonCliLib import AddressFamily
from IpLibConsts import DEFAULT_VRF
import Tac

FwdType = Tac.Type( 'McastCommon::BessAgentConfig::Forwarding' )

PHY_CONFIG_DIR = f'hardware/cell/{Cell.cellId()}/phy/sfe/config'

RouterMulticastAfConfigMode.addCommandSequence( 'McastSfe.vrf.af.config',
                                                after=[ 'Multicast.vrf.af.config' ] )

@CliSave.saver( 'McastCommon::BessAgentConfig',
                'bess/config',
                requireMounts=( 'routing/multicast/legacyconfig',
                                'routing6/hardware/status',
                                'routing/hardware/status',
                                PHY_CONFIG_DIR ) )
def saveBess( entity, root, requireMounts, options ):
   multicastLegacyConfig = requireMounts[ 'routing/multicast/legacyconfig' ]
   hwPlatform = requireMounts[ PHY_CONFIG_DIR ].isSfeSecondaryForwardingAgent
   version = getCliSaveVersion( multicastLegacyConfig.version, True )

   if ( version < multicastLegacyConfig.ipMode ) or ( not hwPlatform ):
      return

   # Always show until kernel eventually retires
   cmds = getCmdRoot( root, DEFAULT_VRF, AddressFamily.ipv6,
                      multicastLegacyConfig.ipMode,
                      prefix='McastSfe' )
   if entity.v6Forwarding == FwdType.sfe:
      cmds.addCommand( 'software-forwarding sfe' )
   elif options.saveCleanConfig:
      cmds.addCommand( 'software-forwarding kernel' )

   cmds = getCmdRoot( root, DEFAULT_VRF, AddressFamily.ipv4,
                      multicastLegacyConfig.ipMode,
                      'McastSfe' )
   if entity.v4Forwarding == FwdType.sfe:
      cmds.addCommand( 'software-forwarding sfe' )
   elif options.saveCleanConfig:
      cmds.addCommand( 'software-forwarding kernel' )
