#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliSave
from CliSavePlugin.RoutingBgpCliSave import (
      RouterBgpBaseConfigMode,
      showBgpConfigInstanceCallbacks,
      evaluateTristate
      )
from RouteMapLib import isAsdotConfigured

def vpnExportMethodConfig( bgpConfig, dvBgpConfig, saveAll ):
   cmd = 'vpn layer-%s export paths %s'
   cmds = []
   # layer-2 (TBD)
   # layer-3
   isSet, val = evaluateTristate( bgpConfig, dvBgpConfig, 'vpnExportMethodL3Best' )
   if isSet or saveAll:
      cmds.append( cmd % ( 3, 'best' if val else 'all' ) )
   return cmds

def showVpnExportMethodConfig( bgpConfig ):
   if cmds := vpnExportMethodConfig( bgpConfig, bgpConfig, False ):
      return { None: cmds }
   return {}

showBgpConfigInstanceCallbacks.append( showVpnExportMethodConfig )

@CliSave.saver( 'Routing::Bgp::Config', 'routing/bgp/config',
                requireMounts=( 'routing/bgp/asn/config', ) )
def saveVpnExportMethodConfig( bgpConfig, root, requireMounts, options ):
   asnConfig = requireMounts[ 'routing/bgp/asn/config' ]
   # If a BGP instance is not configured, do not generate any config
   if bgpConfig.asNumber == 0:
      return

   bgpMode = root[ RouterBgpBaseConfigMode ].getOrCreateModeInstance( (
      bgpConfig.asNumber, isAsdotConfigured( asnConfig ), ) )

   cmds = vpnExportMethodConfig( bgpConfig, bgpConfig, options.saveAll )
   for cmd in cmds:
      bgpMode[ 'Bgp.config' ].addCommand( cmd )
