# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from Tracing import Handle, t0
import CliSave

from CliMode.CcfAgent import CcfMode

__defaultTraceHandle__ = Handle( 'CcfAgent' )

class CcfConfigSaveMode( CcfMode, CliSave.Mode ):

   def __init__( self, param ):
      CcfMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( CcfConfigSaveMode )
CcfConfigSaveMode.addCommandSequence( 'CcfAgent.config' )

@CliSave.saver( 'Ccf::Config', 'ccf/config' )
def saveCcfConfig( entity, root, sysdbRoot, options ):
   t0( 'saveCcfConfig => active=' + str( entity.active ) )
   if entity.active:
      mode = root[ CcfConfigSaveMode ].getSingletonInstance()
      cmds = mode[ 'CcfAgent.config' ]
      cmds.addCommand( 'active' )
