# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import Tac
from CliSavePlugin.IntfCliSave import IntfConfigMode

CliSave.GlobalConfigMode.addCommandSequence( 'ConfigTag.config',
                                             before=[ IntfConfigMode ] )

configTagState = Tac.Type( "ConfigTag::ConfigTagState" )

@CliSave.saver( 'ConfigTag::ConfigTagConfig', 'configTag/config',
      commandTagSupported=True )
def saveConfigTagConfig( entity, root, requireMounts, options ):
   configTagColl = entity.configTagEntry
   for configTag in sorted( configTagColl ):
      cmdStr = 'command-tag %s' % configTag
      configTagEntry = configTagColl[ configTag ]
      if configTagEntry.operState == configTagState.disabled:
         cmdStr += ' disabled'
      elif configTagEntry.operState == configTagState.disassociated:
         cmdStr = cmdStr + ' disassociated'
      root[ 'ConfigTag.config' ].addCommand( cmdStr )
