#!/usr/bin/env python3
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin.TeCliSave import RouterGlobalTeMode

RouterGlobalTeMode.addCommandSequence( 'Cspf.config' )

@CliSave.saver( 'Cspf::CspfCliConfig', 'te/cspf/cliConfig',
                requireMounts=( 'te/config', ) )
def saveCspfTimerConfig( cspfConfig, root, requireMounts, options ):
   teConfig = requireMounts[ 'te/config' ]
   if teConfig.enabled == teConfig.enabledDefault:
      return
   mode = root[ RouterGlobalTeMode ].getSingletonInstance()
   cmds = mode[ 'Cspf.config' ]
   if cspfConfig.cspfTimer.cspfBackOffInt != cspfConfig.cspfBackOffIntDefault or \
      cspfConfig.cspfTimer.cspfInitialInt != cspfConfig.cspfInitialIntDefault or \
      options.saveAll:
      # pylint: disable-next=consider-using-f-string
      cmds.addCommand( 'cspf delay initial %d back-off %d max %d' %
                     ( cspfConfig.cspfTimer.cspfInitialInt,
                        cspfConfig.cspfTimer.cspfBackOffInt,
                        cspfConfig.cspfTimer.cspfMaxInt ) )
   elif cspfConfig.cspfTimer.cspfMaxInt != cspfConfig.cspfMaxIntDefault:
      # pylint: disable-next=consider-using-f-string
      cmds.addCommand( 'cspf delay max %d' % cspfConfig.cspfTimer.cspfMaxInt )
