# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliMode.Classification import FieldSetPrefixModeBase
from CliMode.DirectedBroadcast import (
      DirectedBroadcastModeBase,
      DirectedBroadcastConfigMode,
)
import CliSave

hostsConfigPath = 'directed-broadcast/config/hosts'

class DirectedBroadcastSaveMode( DirectedBroadcastModeBase, CliSave.Mode ):
   def __init__( self, param ):
      DirectedBroadcastModeBase.__init__( self )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( DirectedBroadcastSaveMode )
DirectedBroadcastSaveMode.addCommandSequence( 'DirectedBroadcast.DirectedBroadcast' )

class FSPrefixSaveMode( FieldSetPrefixModeBase, CliSave.Mode ):
   def __init__( self, param ):
      FieldSetPrefixModeBase.__init__( self, param )
      CliSave.Mode.__init__( self, param )

DirectedBroadcastSaveMode.addChildMode( FSPrefixSaveMode )
FSPrefixSaveMode.addCommandSequence( 'DirectedBroadcast.FieldSetPrefix' )

class DirectedBroadcastSaver:
   directedBroadcastMode = DirectedBroadcastSaveMode
   directedBroadcastConfigMode = DirectedBroadcastConfigMode
   feature = "ipdb"
   directedBroadcastCmdSeq = "DirectedBroadcast.DirectedBroadcast"
   fieldSetPrefixCmdSeq = "DirectedBroadcast.FieldSetPrefix"

   def __init__( self, entity, root, requireMounts, options,
                 commentKey="ip-directed-broadcast" ):
      self.entity = entity
      self.root = root
      self.requireMounts = requireMounts
      self.options = options
      self.commentKey = commentKey

   def saveSourceFieldSetCmd( self, directedBcastMode ):
      currentFieldSetName = self.entity.currentFieldSetName
      if currentFieldSetName:
         cmds = directedBcastMode[ self.directedBroadcastCmdSeq ]
         cmd = "source host field-set %s action forward" % currentFieldSetName
         cmds.addCommand( cmd )

   def saveFieldSetAll( self, directedBcastMode ):
      for fieldSetName in sorted( self.entity.fieldSetIpPrefix.keys() ):
         if not self.entity.fieldSetIpPrefix[ fieldSetName ].currCfg:
            continue

         fieldSet = self.entity.fieldSetIpPrefix[ fieldSetName ]
         param = ( self.feature, fieldSet.af,
                   fieldSetName, self.directedBroadcastConfigMode )
         directedBcastFieldSetMode = directedBcastMode[ FSPrefixSaveMode ]\
                                         .getOrCreateModeInstance( param )
         cmds = directedBcastFieldSetMode[ self.fieldSetPrefixCmdSeq ]
         prefixes = [ prefix.stringValue for prefix in
                      sorted( fieldSet.currCfg.prefixes ) ]
         cmd = " ".join( prefixes )
         if cmd:
            cmds.addCommand( cmd )
         # except prefix is not currently supported.
         # Except commands will be added once support is enabled.

   def save( self ):
      if self.entity.fieldSetIpPrefix.keys() or\
         self.entity.currentFieldSetName or\
         CliSave.hasComments( self.commentKey, self.requireMounts ):

         directedBcastMode = \
            self.root[ self.directedBroadcastMode ].getOrCreateModeInstance( None )
         self.saveFieldSetAll( directedBcastMode )
         self.saveSourceFieldSetCmd( directedBcastMode )

# Save DirectedBroadcast Hosts Config
@CliSave.saver( 'DirectedBroadcast::HostsConfig', hostsConfigPath,
                requireMounts=( 'cli/config', ) )
def saveDirectedBroadcastConfig( entity, root, requireMounts, options ):
   cliDumper = DirectedBroadcastSaver( entity, root, requireMounts, options )
   cliDumper.save()
