#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
# pylint: disable-next=consider-using-from-import
import CliSavePlugin.Management as Management
import Tac

class DmfConfigMode( Management.MgmtConfigMode ):
   def __init__( self, param ):
      Management.MgmtConfigMode.__init__( self, 'dmf' )

   def skipIfEmpty( self ):
      return True

CliSave.GlobalConfigMode.addChildMode( DmfConfigMode )
DmfConfigMode.addCommandSequence( "Dmf" )

@CliSave.saver( 'Dmf::Cli::Config', 'dmf/cli/config',
                requireMounts=( 'tapagg/hwstatus', ) )
def saveDmfConfig( config, root, requireMounts, options ):
   # only do saveAll if DMF is supported
   saveAll = options.saveAll and requireMounts[ 'tapagg/hwstatus' ].dmfSupported
   mode = root[ DmfConfigMode ].getSingletonInstance()
   cmds = mode[ 'Dmf' ]

   if config.enabled:
      cmds.addCommand( "no disabled" )
   elif saveAll:
      cmds.addCommand( "disabled" )

   if config.controller:
      addrs = ' '.join( str( k ) for k in config.controller )
      # pylint: disable-next=consider-using-f-string
      cmds.addCommand( "controller address %s" % addrs )
   elif saveAll:
      cmds.addCommand( "no controller address" )
