# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import

import CliSave
from CliSavePlugin.IntfCliSave import IntfConfigMode
from CliSavePlugin import IntfCliSave

IntfConfigMode.addCommandSequence(
   'DpsIntf.config', after=[ 'Arnet.intf' ] )

@CliSave.saver( 'Interface::DpsIntfConfig', 'interface/config/dps/intf',
                attrName='intfConfig', requireMounts=( 'interface/status/all', ) )
def saveDpsIntfConfig( entity, root, requireMounts, options ):
   # Save the baseclass (Interface::IntfConfig) attributes.
   IntfCliSave.saveIntfConfig( entity, root, requireMounts, options )
