# Copyright (c) 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import socket, CliSave, EosVersion

def addHeader( sysdbRoot, options ):
   vi = EosVersion.VersionInfo( sysdbRoot )
   where = socket.gethostname()
   model = vi.modelName() or "unknown-hardware"
   version = vi.version() or "unknown-version"
   return f"! device: {where} ({model}, EOS-{version})\n"

CliSave.addHeaderHook( addHeader, 0 )
