#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.EosSdkRpc import MgmtEosSdkRpcMode, EosSdkRpcTransportMode
from EosSdkRpcAgentLib import RpcConfigConstants
from Toggles import EosSdkRpcToggleLib
import Tac

class MgmtEosSdkRpcSaveMode( MgmtEosSdkRpcMode, CliSave.Mode ):
   def __init__( self, param ):
      MgmtEosSdkRpcMode.__init__( self )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

class EosSdkRpcTransportSaveMode( EosSdkRpcTransportMode, CliSave.Mode ):
   def __init__( self, param ):
      EosSdkRpcTransportMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( MgmtEosSdkRpcSaveMode )
MgmtEosSdkRpcSaveMode.addCommandSequence( "Mgmt.eossdkrpc" )

MgmtEosSdkRpcSaveMode.addChildMode( EosSdkRpcTransportSaveMode )
EosSdkRpcTransportSaveMode.addCommandSequence( "Mgmt.eossdkrpc.transport" )

@CliSave.saver( "Tac::Dir", "eossdkrpc/server/config" )
def saveEosSdkRpc( entity, root, requireMounts, options ):
   parentMode = root[ MgmtEosSdkRpcSaveMode ].getSingletonInstance()
   for serverName, config in entity.items():
      mode = parentMode[ EosSdkRpcTransportSaveMode ].getOrCreateModeInstance(
            serverName )
      cmds = mode[ "Mgmt.eossdkrpc.transport" ]

      if config.localInterface.intfId:
         localIntfCmd = f"local interface {config.localInterface.intfId}"
         if config.localInterface.port != RpcConfigConstants.portDefault:
            localIntfCmd += f" port {config.localInterface.port}"
         cmds.addCommand( localIntfCmd )
      if config.localhostLoopback:
         localLoopbackCmd = "localhost loopback"
         if config.localhostLoopback.port and config.localhostLoopback.port != 9543:
            localLoopbackCmd += f" port {config.localhostLoopback.port}"
         if config.localhostLoopback.vrfName and \
               config.localhostLoopback.vrfName != 'default':
            localLoopbackCmd += f" vrf {config.localhostLoopback.vrfName}"
         cmds.addCommand( localLoopbackCmd )
      if config.unixEndpointAddress:
         cmds.addCommand(
               f"localhost unix-socket {config.unixEndpointAddress.path}" )
      if EosSdkRpcToggleLib.toggleEosSdkRpcAclVrfEnabled():
         if config.vrfName:
            cmds.addCommand( f"vrf {config.vrfName}" )
      if EosSdkRpcToggleLib.toggleEosSdkRpcAclEnabled():
         if config.serviceAcl:
            cmds.addCommand( f"ip access-group {config.serviceAcl} in" )
      if config.enableAllServices:
         cmds.addCommand( "service all" )
      elif config.servicesEnabled:
         cmds.addCommand(
               "service {}".format( # pylint: disable=consider-using-f-string
               " ".join( sorted( config.servicesEnabled ) ) ) )
      if config.sslProfile:
         cmds.addCommand( f"ssl profile {config.sslProfile}" )
      if config.usernameAuthSecure:
         cmds.addCommand( "metadata username authentication channel secure" )
      if config.accounting:
         cmds.addCommand( "accounting requests all logging" )
      if config.enabled:
         cmds.addCommand( "no disabled" )
