# Copyright (c) 2006, 2007, 2008, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string

#-------------------------------------------------------------------------------
# This module implements CliSave for the Errdisable commands
#-------------------------------------------------------------------------------

import CliSave
import ErrdisableCliLib
from ErrdisableCliLib import causeNameWithoutSliceId
import Tracing

traceDetail = Tracing.trace2

CliSave.GlobalConfigMode.addCommandSequence( 'Errdisable' )


@CliSave.saver( 'Errdisable::Config', 'interface/errdisable/config',
                requireMounts = ( 'interface/errdisable/causegroup', ) )
def saveErrdisableConfig( entity, root, requireMounts, options ):
   cmds = root[ 'Errdisable' ]
   causeGroupDir = requireMounts[ "interface/errdisable/causegroup" ]
   disabledDetectCauses = set()
   enabledDetectCauses = set()
   recoveryCauses = set()
   saveAll = options.saveAll

   if saveAll:
      # Get the detect and recovery causes.
      for causeGroup in ErrdisableCliLib.getCauseGroups( causeGroupDir ):
         strippedName = causeNameWithoutSliceId( causeGroup )
         if not causeGroupDir[ causeGroup ].hiddenCause and \
            causeGroupDir[ causeGroup ].installCauseEnableCliCmd:
            disabledDetectCauses.add( strippedName )
            enabledDetectCauses.add( strippedName )

         if not causeGroupDir[ causeGroup ].hiddenCause and \
            causeGroupDir[ causeGroup ].installCauseRecoveryCliCmd:
            recoveryCauses.add( strippedName )
   else:
      disabledDetectCauses = set( entity.disabled )
      enabledDetectCauses = set( entity.enabled )
      recoveryCauses = set( entity.timerRecoveryEnabled )
 
   #
   # 'errdisable detect cause ...' command
   # By default the cause detection is enabled, so generate the 'no'
   # version of the detect cause for the cause that are disabled.
   #
   for cause in sorted( disabledDetectCauses ):
      if cause in entity.disabled:
         if cause == 'link-flap':
            cause = 'link-change'
         cmds.addCommand( 'no errdisable detect cause %s' % cause )

   for cause in sorted( enabledDetectCauses ):
      if cause in entity.enabled:
         if cause == 'link-flap':
            cause = 'link-change'
         cmds.addCommand( 'errdisable detect cause %s' % cause )
   #
   # 'errdisable recovery cause ...' command
   #
   for cause in sorted( recoveryCauses ):
      if cause in entity.timerRecoveryEnabled:
         cmds.addCommand( 'errdisable recovery cause %s' % cause )
      else:
         cmds.addCommand( 'no errdisable recovery cause %s' % cause )
   
   for ( cause, recInt ) in sorted( entity.causeRecoveryInterval.items() ):
      cmds.addCommand( 'errdisable recovery cause %s interval %i' % ( cause,
         recInt ) )

   if entity.recoveryInterval != entity.defaultRecoveryInterval or saveAll:
      cmds.addCommand( 'errdisable recovery interval %d' % entity.recoveryInterval )

