# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave

CliSave.GlobalConfigMode.addCommandSequence( 'Fpga.config' )

@CliSave.saver( 'Hardware::Fpga::FpgaCliConfig', 'hardware/fpga/cliConfig',
                requireMounts=( 'hardware/entmib', ) )
def saveFpgaCliConfig( entity, root, requireMounts, options ):
   cmds = root[ 'Fpga.config' ]
   if requireMounts[ 'hardware/entmib' ].chassis:
      if entity.linecardFpgaCrcRecoveryMode == 'fpgaCrcRecoveryPowerCycle':
         cmds.addCommand( 'hardware fpga error linecard action power-cycle' )
      elif options.saveAll or options.saveAllDetail:
         cmds.addCommand( 'hardware fpga error linecard action log' )
      if entity.fpgaCrcRecoveryMode == 'fpgaCrcRecoveryPowerCycle':
         cmds.addCommand( 'hardware fpga error supervisor action power-cycle' )
      elif options.saveAll or options.saveAllDetail:
         cmds.addCommand( 'hardware fpga error supervisor action log' )
   elif requireMounts[ 'hardware/entmib' ].fixedSystem:
      if entity.fpgaCrcRecoveryMode == 'fpgaCrcRecoveryPowerCycle':
         cmds.addCommand( 'hardware fpga error action power-cycle' )
      elif entity.fpgaCrcRecoveryMode == 'fpgaCrcRecoveryAutoRepair':
         cmds.addCommand( 'hardware fpga error action repair' )
      elif options.saveAll or options.saveAllDetail:
         cmds.addCommand( 'hardware fpga error action log' )
