# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliSave

from CliSavePlugin import IntfCliSave
from CliSavePlugin.IntfCliSave import IntfConfigMode

IntfConfigMode.addCommandSequence( 'RecircIntf.intfConfig', after=[ 'Arnet.intf' ] )

@CliSave.saver( 'Interface::InternalRecircIntfConfig', 'interface/config/recirc',
                attrName='intfConfig',
                requireMounts=( 'interface/status/all', ) )
def saveRecircIntfConfig( entity, root, requireMounts, options ):
   # Save the baseclass (Arnet::IntfConfig) attributes.
   IntfCliSave.saveIntfConfig( entity, root, requireMounts, options )
