# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliSave
from CliMode.IntfProfile import IntfProfileMode
from CliSavePlugin.IntfCliSave import IntfConfigMode, INTF_PROFILE_CMD_SEQ_NAME

class IntfProfileConfigModeBase( IntfProfileMode, CliSave.Mode ):
   def __init__( self, param ):
      IntfProfileMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

class IntfProfileLegacyConfigMode( IntfProfileConfigModeBase ):
   pass

class IntfProfileConfigMode( IntfProfileConfigModeBase ):
   pass

# This is the legacy mode defined before interface modes
CliSave.GlobalConfigMode.addChildMode( IntfProfileLegacyConfigMode,
                                       before=[ IntfConfigMode ] )
IntfProfileLegacyConfigMode.addCommandSequence( 'IntfProfile.config' )

# This is after interface modes for better performance
CliSave.GlobalConfigMode.addChildMode( IntfProfileConfigMode,
                                       after=[ IntfConfigMode ] )
IntfProfileConfigMode.addCommandSequence( 'IntfProfile.config' )

@CliSave.saver( 'IntfProfile::Config', 'interface/profile/config' )
def saveIntfProfileConfig( entity, root, requireMounts, options ):
   saveIntfProfileMode( entity, root )
   saveIntfProfileAssociations( entity, root )

def saveIntfProfileMode( entity, root ):
   for profileName in sorted( entity.profile ):
      if entity.useOverrideCmd:
         modeClass = IntfProfileConfigMode
      else:
         modeClass = IntfProfileLegacyConfigMode
      mode = root[ modeClass ].getOrCreateModeInstance( profileName )
      cmds = mode[ 'IntfProfile.config' ]
      profile = entity.profile[ profileName ]
      for command in profile.command.values():
         # pylint: disable-next=consider-using-f-string
         cmds.addCommand( 'command %s' % command )

def saveIntfProfileAssociations( entity, root ):
   for intf, profileAppCfg in entity.intfToProfile.items():
      mode = root[ IntfConfigMode ].getOrCreateModeInstance( intf )
      cmds = mode[ INTF_PROFILE_CMD_SEQ_NAME ]
      cmds.addCommand( 'profile %s' % # pylint: disable=consider-using-f-string
                       ' '.join( profileAppCfg.profile.values() ) )

