# Copyright (c) 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliSavePlugin.IntfCliSave import IntfConfigMode
import CliSave
import Tac

IntfConfigMode.addCommandSequence( 'IntfSnmp.intf' )

def isInternal( intfName ):
   return intfName.startswith( "Internal" )

#-------------------------------------------------------------------------------
# Saves the state of an Interface::TestIntfConfig object.
#-------------------------------------------------------------------------------
@CliSave.saver( 'Snmp::Interface::Config', 'snmp/interface/config',
                requireMounts = ( 'interface/config/all', ) )
def saveIntfSnmpConfig( entity, root, requireMounts, options ):
   saveAll = options.saveAll
   if saveAll:
      # Get the list of all interfaces 
      intfConfigDir = requireMounts[ 'interface/config/all' ]
      cfgIntfNames = ( intfName for intfName in intfConfigDir.intfConfig
                       if not isInternal( intfName ) )
   else:
      cfgIntfNames = entity.trapConfig

   # Snmp/SnmpCliSave has all the "snmp-server" commands. Therefore, lets group
   # them together.
   cmds = root[ 'Snmp.global' ]
   if entity.useShapeRate:
      cmds.addCommand( 'snmp-server ifmib ifspeed shape-rate' )
   elif saveAll:
      cmds.addCommand( 'no snmp-server ifmib ifspeed shape-rate' )

   for intfName in cfgIntfNames:
      intfId = Tac.Value( 'Arnet::IntfId', stringValue=intfName )
      trapCfg = entity.trapConfig.get( intfId )
      if trapCfg is None:
         if saveAll:
            trapCfg = Tac.newInstance( 'Snmp::Interface::TrapConfig' )
         else:
            continue
      mode = root[ IntfConfigMode ].getOrCreateModeInstance( intfName )
      cmds = mode[ 'IntfSnmp.intf' ]
      if trapCfg != Tac.Value( 'Snmp::Interface::TrapConfig' ):
         # pylint: disable-next=consider-using-f-string
         cmds.addCommand( '%ssnmp trap link-change' %
                          ( '' if trapCfg.linkStatusEnable else 'no ' ) )
      elif saveAll:
         # default case should always have the new syntax
         cmds.addCommand( 'snmp trap link-change' )
