# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from TypeFuture import TacLazyType
import CliSave
from CliSavePlugin.IraCliSave import RouterKernelCliSaveMode
from CliMode.KernelFib import RouterKernelAfMode

kernelFibConstants = TacLazyType( 'KernelFib::KernelFibConstants' )

class RouterKernelAfCliSaveMode( RouterKernelAfMode, CliSave.Mode ):
   def __init__( self, param ):
      RouterKernelAfMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

RouterKernelCliSaveMode.addChildMode( RouterKernelAfCliSaveMode )
RouterKernelAfCliSaveMode.addCommandSequence( 'Router.kernel.ipv4' )
RouterKernelAfCliSaveMode.addCommandSequence( 'Router.kernel.ipv6' )
CliSave.GlobalConfigMode.addCommandSequence( 'KernelSoftwareFwd' )

def saveRouterKernelVrfConfigs( entity, root, options, af ):
   for vrfName in sorted( entity.vrfConfig ):
      vrfMode = root[
         RouterKernelCliSaveMode ].getOrCreateModeInstance(  vrfName  )

      vrfAfMode = vrfMode[
         RouterKernelAfCliSaveMode ].getOrCreateModeInstance( ( vrfName, af ) )

      cmds = vrfAfMode[ 'Router.kernel.' + af ]
      cfg = entity.vrfConfig[ vrfName ]

      if cfg.preference != kernelFibConstants.defaultPreference() or options.saveAll:
         cmds.addCommand( f'distance {cfg.preference}' )

      cmdBase = 'software forwarding hardware offload route local interface'
      if cfg.hwOffloadLocalIntfName:
         cmds.addCommand( f'{cmdBase} {cfg.hwOffloadLocalIntfName}' )
      elif options.saveAll:
         cmds.addCommand( f'no {cmdBase}' )

      cmdBase = 'software forwarding hardware offload route rcf'
      if cfg.hwOffloadRcfName:
         cmds.addCommand( f'{cmdBase} {cfg.hwOffloadRcfName}()' )
      elif options.saveAll:
         cmds.addCommand( f'no {cmdBase}' )

      cmdHwOffloadHwRouteLookup = \
            'software forwarding hardware offload route lookup bgp' 
      if cfg.hwOffloadDefaultRoute:
         cmds.addCommand( f'{cmdHwOffloadHwRouteLookup}' )
      elif options.saveAll:
         cmds.addCommand( f'no {cmdHwOffloadHwRouteLookup}' )

      if cfg.standbyRouteCol:
         routeCol = cfg.standbyRouteCol.routes
         for prefix, routes in sorted( routeCol.items() ):
            for via in routes.vias:
               nextHop = str( via.hop )
               intfId = str( via.intfId )
               cmds.addCommand( f'standby route {prefix} {intfId} {nextHop}' )

   if entity.programAllEcmpPaths:
      cmds = root['KernelSoftwareFwd']
      cmds.addCommand( 'kernel software forwarding ecmp' )

@CliSave.saver( 'KernelFib::KernelRouteConfigDir', 'routing/kernel/config' )
def saveRouterKernelConfig( entity, root, requireMounts, options ):
   saveRouterKernelVrfConfigs( entity, root, options, 'ipv4' )

@CliSave.saver( 'KernelFib::KernelRouteConfigDir', 'routing6/kernel/config' )
def saveRouter6KernelConfig( entity, root, requireMounts, options ):
   saveRouterKernelVrfConfigs( entity, root, options, 'ipv6' )
