#!/usr/bin/env python3
# Copyright (c) 2009, 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
from CliSavePlugin.IntfCliSave import IntfConfigMode
import CliSave
import Toggles.MlagToggleLib

IntfConfigMode.addCommandSequence( 'Mlag.lagIntf', after=[ 'Lag.lagIntf' ] )

if Toggles.MlagToggleLib.toggleMlagL2SubinterfacesEnabled():
   path = 'mlag/input/config/cli'
else:
   path = 'mlag/config'

@CliSave.saver( 'Mlag::Config', path,
                requireMounts=( 'mlag/hardware/status',
                                'interface/config/eth/lag' ) )

def saveLagIntfMlag( entity, root, requireMounts, options ):
   # Display config only if mlag is supported by the hardware
   mlagHardwareStatus = requireMounts[ 'mlag/hardware/status' ]
   saveAll = options.saveAll
   saveAllDetail = options.saveAllDetail # pylint: disable=unused-variable

   if not mlagHardwareStatus.mlagSupported:
      saveAll = False
      saveAllDetail = False

   if saveAll:
      # Get the list of interface names from interface/config/eth/lag 
      lagEthIntfConfigDir = requireMounts[ 'interface/config/eth/lag' ]
      cfgLagNames = lagEthIntfConfigDir.intfConfig
   else:
      cfgLagNames = entity.intfConfig

   for k in cfgLagNames:
      v = entity.intfConfig.get( k )
      if v:
         cmd = 'mlag %s' % v # pylint: disable=consider-using-f-string
      elif saveAll:
         cmd = 'no mlag'
      else:
         continue

      mode = root[ IntfConfigMode ].getOrCreateModeInstance( k )
      cmds = mode[ 'Mlag.lagIntf' ]
      cmds.addCommand( cmd )
