# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliSave
from CliSavePlugin import Management

class ArchiveConfigMode( Management.MgmtConfigMode ):
   def __init__( self, param ):
      super().__init__( "archive" )

CliSave.GlobalConfigMode.addChildMode( ArchiveConfigMode )
ArchiveConfigMode.addCommandSequence( 'Mgmt.archive' )

@CliSave.saver( 'Mgmt::Archive::Config', 'mgmt/archive/config' )
def saveArchiveConfig( entity, root, requireMounts, options ):
   """
   The save configuration function for the Arista File Archive.
   """
   if ( entity.shutdown != entity.defaultShutdownState
        or entity.quotapct != entity.defaultQuotaReservedPct
        or entity.dest != entity.defaultDest ):
      mode = root[ ArchiveConfigMode ].getSingletonInstance()
      cmds = mode[ 'Mgmt.archive' ]
      saveAll = options.saveAll

      # 'Archive shutdown' is no shutdown by default, so only generate the
      # command if the shutdown is not set to the default
      if entity.shutdown != entity.defaultShutdownState:
         cmds.addCommand( 'shutdown' )
      elif saveAll:
         cmds.addCommand( 'no shutdown' )

      # 'Archive quotapct' is set to a default % value if not specified
      if entity.quotapct != entity.defaultQuotaReservedPct or saveAll:
         cmds.addCommand( 'quotapct %s' % str( entity.quotapct ) )

      if entity.dest != entity.defaultDest:
         destUrl = entity.dest.split( ':' )[ 0 ] + ':'
         cmds.addCommand( 'destination %s' % destUrl )
