# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin.XcvrCliSave import Layer1MonitorConfigMode

@CliSave.saver( 'Interface::EthPhyIntfGlobalDefaultConfigDir',
               'interface/config/eth/phy/globalDefault' )
def saveMacFaultLoggingConfig( globalDefaultConfig, root, requireMounts, options ):
   if globalDefaultConfig.macFaultLogging:
      mode = root[ Layer1MonitorConfigMode ].getOrCreateModeInstance( None )
      cmds = mode[ 'Layer1Monitor.config' ]
      cmds.addCommand( 'logging mac fault' )
