# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliSave
from CliMode.MatchListCliMode import MatchListMode

class MatchListConfigMode( MatchListMode, CliSave.Mode ):

   def __init__( self, paramTuple ):
      matchListName, inputType = paramTuple
      MatchListMode.__init__( self, matchListName, inputType )
      CliSave.Mode.__init__( self, matchListName )

CliSave.GlobalConfigMode.addChildMode( MatchListConfigMode )
MatchListConfigMode.addCommandSequence( 'MatchStringList.config' )
MatchListConfigMode.addCommandSequence( 'MatchIpv4PrefixList.config' )
MatchListConfigMode.addCommandSequence( 'MatchIpv6PrefixList.config' )

@CliSave.saver( 'MatchList::Config', 'matchlist/config/cli' )
def saveMatchListConfig( entity, root, requireMounts, options ):
   saveMatchStringListConfig( entity, root )
   saveMatchIpv4PrefixListConfig( entity, root )
   saveMatchIpv6PrefixListConfig( entity, root )

def saveMatchStringListConfig( entity, root ):
   for listName, matchList in entity.matchStringList.items():
      mode = root[ MatchListConfigMode ].getOrCreateModeInstance( ( listName,
                                                                    'string' ) )
      cmds = mode[ 'MatchStringList.config' ]
      for seqNo, match in matchList.matchInfo.items():
         # pylint: disable-next=consider-using-f-string
         cmds.addCommand( f'{seqNo} match {match.type} {match.string}' )

def saveMatchIpv4PrefixListConfig( entity, root ):
   for listName in entity.matchIpv4PrefixList:
      mode = root[ MatchListConfigMode ].getOrCreateModeInstance( ( listName,
                                                                    'prefix-ipv4' ) )
      cmds = mode[ 'MatchIpv4PrefixList.config' ]
      for subnet in entity.matchIpv4PrefixList[ listName ].subnets:
         cmd = "match prefix-ipv4"
         cmd += " %s" % subnet.stringValue # pylint: disable=consider-using-f-string
         cmds.addCommand( cmd )

def saveMatchIpv6PrefixListConfig( entity, root ):
   for listName in entity.matchIpv6PrefixList:
      mode = root[ MatchListConfigMode ].getOrCreateModeInstance( ( listName,
                                                                    'prefix-ipv6' ) )
      cmds = mode[ 'MatchIpv6PrefixList.config' ]
      for subnet in entity.matchIpv6PrefixList[ listName ].subnets:
         cmd = "match prefix-ipv6"
         cmd += " %s" % subnet.stringValue # pylint: disable=consider-using-f-string
         cmds.addCommand( cmd )
