#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin.MrouteCliSave import RouterMulticastBaseConfigMode
from CliSavePlugin.MrouteCliSave import RouterMulticastAfConfigMode
from CliSavePlugin.MrouteCliSave import RouterMulticastVrfConfigMode
from McastCommonCliLib import AddressFamily
from IpLibConsts import DEFAULT_VRF

def getCmdRoot( root, vrfName, af ):
   rootMode = root[ RouterMulticastBaseConfigMode ].getSingletonInstance()
   if vrfName == DEFAULT_VRF:
      afMode = rootMode[ RouterMulticastAfConfigMode ].getOrCreateModeInstance(
                  ( vrfName, af ) )
   else:
      vrfMode = rootMode[ RouterMulticastVrfConfigMode ].\
                getOrCreateModeInstance( vrfName )
      afMode = vrfMode[ RouterMulticastAfConfigMode ].getOrCreateModeInstance(
         ( vrfName, af ) )
   return afMode

@CliSave.saver( 'Routing::Multicast::VrfLeak::McastVrfLeakConfig',
                'routing/multicast/vrf/leakConfig' )
def saveMcastVrfLeakIpv4Config( config, root, requireMounts, options ):
   saveMcastVrfLeakConfig( AddressFamily.ipv4, config, root )

@CliSave.saver( 'Routing::Multicast::VrfLeak::McastVrfLeakConfig',
                'routing6/multicast/vrf/leakConfig' )
def saveMcastVrfLeakIpv6Config( config, root, requireMounts, options ):
   saveMcastVrfLeakConfig( AddressFamily.ipv6, config, root )

RouterMulticastAfConfigMode.addCommandSequence( 
   'McastVrfLeak.vrf.af.config', after=[ 'McastStaticRoute.vrf.af.config' ] )
def saveMcastVrfLeakConfig( af, vrfLeakConfig, root ):
   for vrfName in vrfLeakConfig.vrfConfig:
      mode = getCmdRoot( root, vrfName, af )
      cmds = mode[ 'McastVrfLeak.vrf.af.config' ]
      for pfxList in vrfLeakConfig.vrfConfig[ vrfName ].sourceVrfGroups:
         srcVrf = vrfLeakConfig.vrfConfig[ vrfName ].sourceVrfGroups[ pfxList ]
         # pylint: disable-next=consider-using-f-string
         cmds.addCommand( 'leak group prefix-list %s vrf %s' % ( pfxList, srcVrf ) )
