# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.McsClient import McsServiceClientMode, McsServiceClientSecondaryCvxMode
from CliSavePlugin.ControllerClient import saveMgmtCvxConfigHelper
import Tac
from TypeFuture import TacLazyType

Constants = TacLazyType( "Controller::Constants" )

class McsServiceClientConfigSaveMode( McsServiceClientMode, CliSave.Mode ):
   def __init__( self, param ):
      McsServiceClientMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( McsServiceClientConfigSaveMode )
McsServiceClientConfigSaveMode.addCommandSequence( "McsServiceClient.config" )

class McsServiceClientSecondaryCvxConfigSaveMode( McsServiceClientSecondaryCvxMode,
      CliSave.Mode ):
   def __init__( self, param ):
      McsServiceClientSecondaryCvxMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

McsServiceClientConfigSaveMode.addChildMode(
      McsServiceClientSecondaryCvxConfigSaveMode )

McsServiceClientSecondaryCvxConfigSaveMode.addCommandSequence(
      "McsServiceClientSecondaryCvx.config" )

@CliSave.saver( "Mcs::Client::Config", "mcs/switch/config" )
def saveMcsServiceClientConfig( entity, root, requireMounts, options ):
   cmds = []

   if entity.enabled or options.saveAll:
      cmds.append( "no shutdown" if entity.enabled else "shutdown" )

   if cmds:
      mcsServiceClientMode = root[
            McsServiceClientConfigSaveMode ].getSingletonInstance()
      mcsServiceClientMode = mcsServiceClientMode[ "McsServiceClient.config" ]
      for cmd in cmds:
         mcsServiceClientMode.addCommand( cmd )

@CliSave.saver( "ControllerClient::Config", "mcs/switch/controller/config" )
def saveMcsServiceClientSecondaryCvxConfig( entity, root, requireMounts, options ):

   cmds = saveMgmtCvxConfigHelper( entity, root, options )

   if cmds:
      mcsServiceClientMode = root[
            McsServiceClientConfigSaveMode ].getSingletonInstance()

      secondaryCvxMode = mcsServiceClientMode[
            McsServiceClientSecondaryCvxConfigSaveMode ]
      name = entity.clusterName or Constants.clusterDefaultName
      secondaryCvxMode = secondaryCvxMode.getOrCreateModeInstance( name )
      secondaryCvxMode = secondaryCvxMode[ "McsServiceClientSecondaryCvx.config" ]

      for cmd in cmds:
         secondaryCvxMode.addCommand( cmd )
