# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave, Tac
from CliSavePlugin import Management

class MgmtDefaultsConfigMode( Management.MgmtConfigMode ):

   def __init__( self, param ):
      Management.MgmtConfigMode.__init__( self, "defaults" )

   def skipIfEmpty( self ):
      return True

CliSave.GlobalConfigMode.addChildMode( MgmtDefaultsConfigMode )
MgmtDefaultsConfigMode.addCommandSequence( 'Mgmt.defaults' )

@CliSave.saver( 'Mgmt::Defaults::Config', 'mgmt/defaults/config' )
def saveMgmtDefaults( defaultsConfig, root, requireMounts, options ):
   if defaultsConfig.hashAlgorithm != 'sha512' or options.saveAll:
      mode = root[ MgmtDefaultsConfigMode ].getSingletonInstance()
      cmds = mode[ 'Mgmt.defaults' ]
      cmds.addCommand( f"secret hash {defaultsConfig.hashAlgorithm}" )
