# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.Models import (
      ModelsMode,
      ModulesMode,
      MgmtModelsMode,
      ProviderAFTMode,
      ProviderHttpCommandsMode,
      ProviderSmashMode,
      ProviderSysdbMode,
      ProviderIPFIXMode,
      ProviderSflowMode,
      ProviderIsisMode,
      ProviderOspfMode,
      ProviderBgpMode,
      ProviderBgpRibMode,
      ProviderMacsecMode,
      ProviderConfigurationMode,
)
from IpLibConsts import DEFAULT_VRF
import Toggles.OpenConfigToggleLib as OCToggle
import Toggles.RoutingLibToggleLib as RoutingLibToggle


class MgmtModelsSaveMode( MgmtModelsMode, CliSave.Mode ):
   def __init__( self, param ):
      MgmtModelsMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

class ProviderAFTSaveMode( ProviderAFTMode, CliSave.Mode ):
   def __init__( self, param ):
      ProviderAFTMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

class ProviderSmashSaveMode( ProviderSmashMode, CliSave.Mode ):
   def __init__( self, param ):
      ProviderSmashMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

class ProviderSysdbSaveMode( ProviderSysdbMode, CliSave.Mode ):
   def __init__( self, param ):
      ProviderSysdbMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

class ProviderIPFIXSaveMode( ProviderIPFIXMode, CliSave.Mode ):
   def __init__( self, param ):
      ProviderIPFIXMode.__init__( self, param ) 
      CliSave.Mode.__init__( self, param )

class ProviderSflowSaveMode( ProviderSflowMode, CliSave.Mode ):
   def __init__( self, param ):
      ProviderSflowMode.__init__( self, param ) 
      CliSave.Mode.__init__( self, param )

class ProviderHttpCommandsSaveMode( ProviderHttpCommandsMode, CliSave.Mode ):
   def __init__( self, param ):
      ProviderHttpCommandsMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

class ProviderIsisSaveMode( ProviderIsisMode, CliSave.Mode ):
   def __init__( self, param ):
      ProviderIsisMode.__init__( self, param ) 
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

class ProviderOspfSaveMode( ProviderOspfMode, CliSave.Mode ):
   def __init__( self, param ):
      ProviderOspfMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

class ProviderBgpSaveMode( ProviderBgpMode, CliSave.Mode ):
   def __init__( self, param ):
      ProviderBgpMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

class ProviderBgpRibSaveMode( ProviderBgpRibMode, CliSave.Mode ):
   def __init__( self, param ):
      ProviderBgpRibMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

class ProviderMacsecSaveMode( ProviderMacsecMode, CliSave.Mode ):
   def __init__( self, param ):
      ProviderMacsecMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

class ProviderConfigurationSaveMode( ProviderConfigurationMode, CliSave.Mode ):
   def __init__( self, param ):
      ProviderConfigurationMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

class ModelsSaveMode( ModelsMode, CliSave.Mode ):
   def __init__( self, param ):
      ModelsMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

class ModulesSaveMode( ModulesMode, CliSave.Mode ):
   def __init__( self, param ):
      ModulesMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

CliSave.GlobalConfigMode.addChildMode( MgmtModelsSaveMode )
MgmtModelsSaveMode.addCommandSequence( "Mgmt.models" )

MgmtModelsSaveMode.addChildMode( ProviderAFTSaveMode )
ProviderAFTSaveMode.addCommandSequence( 'Mgmt.models.provider.aft' )

MgmtModelsSaveMode.addChildMode( ProviderSmashSaveMode )
ProviderSmashSaveMode.addCommandSequence( 'Mgmt.models.provider.smash' )

MgmtModelsSaveMode.addChildMode( ProviderSysdbSaveMode )
ProviderSysdbSaveMode.addCommandSequence( 'Mgmt.models.provider.sysdb' )

MgmtModelsSaveMode.addChildMode( ProviderIPFIXSaveMode )
ProviderIPFIXSaveMode.addCommandSequence( 'Mgmt.models.provider.ipfix' )

MgmtModelsSaveMode.addChildMode( ProviderSflowSaveMode )
ProviderSflowSaveMode.addCommandSequence( 'Mgmt.models.provider.sflow' )

MgmtModelsSaveMode.addChildMode( ProviderIsisSaveMode )
ProviderIsisSaveMode.addCommandSequence( 'Mgmt.models.provider.isis' )

if RoutingLibToggle.toggleOspf2LsdbExportEnabled():
   MgmtModelsSaveMode.addChildMode( ProviderOspfSaveMode )
   ProviderOspfSaveMode.addCommandSequence( 'Mgmt.models.provider.ospf' )

MgmtModelsSaveMode.addChildMode( ProviderBgpSaveMode )
ProviderBgpSaveMode.addCommandSequence( 'Mgmt.models.provider.bgp' )

ProviderBgpSaveMode.addChildMode( ProviderBgpRibSaveMode )
ProviderBgpRibSaveMode.addCommandSequence( 'Mgmt.models.provider.bgp.bgprib' )

MgmtModelsSaveMode.addChildMode( ProviderMacsecSaveMode )
ProviderMacsecSaveMode.addCommandSequence( 'Mgmt.models.provider.macsec' )

MgmtModelsSaveMode.addChildMode( ProviderConfigurationSaveMode )
ProviderConfigurationSaveMode.addCommandSequence(
      'Mgmt.models.provider.configuration' )

MgmtModelsSaveMode.addChildMode( ProviderHttpCommandsSaveMode )
ProviderHttpCommandsSaveMode.addCommandSequence(
      'Mgmt.models.provider.http-commands' )

MgmtModelsSaveMode.addChildMode( ModelsSaveMode )
ModelsSaveMode.addCommandSequence( 'Mgmt.models.models' )

if OCToggle.toggleOCExclusiveModuleGroupSegmentationToggleEnabled():
   MgmtModelsSaveMode.addChildMode( ModulesSaveMode )
   ModulesSaveMode.addCommandSequence( 'Mgmt.models.modules' )


@CliSave.saver( "Octa::Config", "mgmt/octa/config",
                requireMounts=( 'mgmt/gnmi/config', 'cli/config' ) )
def saveModels( octaConfig, root, requireMounts, options ):
   saveAll = options.saveAll
   gnmiConfig = requireMounts[ 'mgmt/gnmi/config' ]
   ecoOptions = octaConfig.ecoOptions
   macsecOptions = octaConfig.macsecOptions

   parentMode = root[ MgmtModelsSaveMode ].getSingletonInstance()
   parentCmds = parentMode[ "Mgmt.models" ]

   # provider aft
   mode = parentMode[ ProviderAFTSaveMode ].getSingletonInstance()
   cmds = mode[ "Mgmt.models.provider.aft" ]

   if octaConfig.aftOptions.ipv4Unicast:
      cmds.addCommand( "ipv4-unicast" )
   elif saveAll:
      cmds.addCommand( "no ipv4-unicast" )

   if octaConfig.aftOptions.ipv6Unicast:
      cmds.addCommand( "ipv6-unicast" )
   elif saveAll:
      cmds.addCommand( "no ipv6-unicast" )

   if OCToggle.toggleOCLfibAftEnabled():
      if octaConfig.aftOptions.mpls:
         cmds.addCommand( "mpls" )
      elif saveAll:
         cmds.addCommand( "no mpls" )

   if RoutingLibToggle.toggleRouteSummaryPublishEnabled():
      if octaConfig.aftOptions.routeSummary:
         cmds.addCommand( "route-summary" )
      elif saveAll:
         cmds.addCommand( "no route-summary" )

   # provider bgp
   mode = parentMode[ ProviderBgpSaveMode ].getSingletonInstance()
   bribMode = mode[ ProviderBgpRibSaveMode ].getSingletonInstance()
   cmds = bribMode[ "Mgmt.models.provider.bgp.bgprib" ]
   if octaConfig.bgpRibIpv4Unicast:
      cmds.addCommand( "ipv4-unicast" )
   elif saveAll:
      cmds.addCommand( "no ipv4-unicast" )

   if octaConfig.bgpRibIpv6Unicast:
      cmds.addCommand( "ipv6-unicast" )
   elif saveAll:
      cmds.addCommand( "no ipv6-unicast" )

   # provider smash
   mode = parentMode[ ProviderSmashSaveMode ].getSingletonInstance()
   cmds = mode[ "Mgmt.models.provider.smash" ]

   for path in octaConfig.smashIncludes.values():
      if path == "":
         break
      cmds.addCommand( f"path {path}" )

   for path in octaConfig.smashExcludes.values():
      if path == "":
         break
      cmds.addCommand( f"path {path} disabled" )

   # provider sysdb
   mode = parentMode[ ProviderSysdbSaveMode ].getSingletonInstance()
   cmds = mode[ "Mgmt.models.provider.sysdb" ]
   for path in sorted( octaConfig.sysdbExcludes.items() ):
      cmds.addCommand( f"path {path[ 0 ]} disabled" )

   # provider ipfix
   if ecoOptions and ecoOptions.ipfixEnableCollector:
      mode = parentMode[ ProviderIPFIXSaveMode ].getSingletonInstance()
      cmds = mode[ "Mgmt.models.provider.ipfix" ]
      # if IP and port default: no listener command
      # if IP non-default but port default: just listener <port>
      # if port non-default: listener <ip> <port>
      if ecoOptions.ipfixPort != 4739 or saveAll:
         cmds.addCommand( "listener {} port {}".format(
            ecoOptions.ipfixAddress, ecoOptions.ipfixPort ) )
      elif ecoOptions.ipfixAddress != "127.0.0.1":
         cmds.addCommand( f"listener {ecoOptions.ipfixAddress}" )

      if ecoOptions.ipfixDomain != 'default' or saveAll:
         cmds.addCommand( f"domain {ecoOptions.ipfixDomain}" )

      # if flow table size and lifetime default: no flow command
      # if flow table size not-default but lifetime default:
      #     flow table size <size>
      # if flow lifetime not-default but table size default:
      #     flow lifetime <lifetime> seconds
      # if both not-default:
      #     flow table size <size> lifetime <lifetime> seconds
      tableSize = ""
      if ecoOptions.ipfixFlowTableSize != 16384 or saveAll:
         tableSize = f" table size {ecoOptions.ipfixFlowTableSize}"
      lifetime = ""
      if ecoOptions.ipfixFlowLifetime != 300 or saveAll:
         lifetime = f" lifetime {ecoOptions.ipfixFlowLifetime} seconds"
      if tableSize or lifetime:
         cmds.addCommand( f"flow{tableSize}{lifetime}" )
   elif saveAll:
      # we can do this because ipfix has skipIfEmpty=False
      parentCmds.addCommand( "no provider ipfix" )

   # provider sflow
   if ecoOptions and ecoOptions.sflowEnableCollector:
      mode = parentMode[ ProviderSflowSaveMode ].getSingletonInstance()
      cmds = mode[ "Mgmt.models.provider.sflow" ]
      # if IP and port default: no listener command
      # if IP non-default but port default: just listener <port>
      # if port non-default: listener <ip> <port>
      if ecoOptions.sflowPort != 6343 or saveAll:
         cmds.addCommand( "listener {} port {}".format(
            ecoOptions.sflowAddress, ecoOptions.sflowPort ) )
      elif ecoOptions.sflowAddress != "127.0.0.1":
         cmds.addCommand( f"listener {ecoOptions.sflowAddress}" )

      if ecoOptions.sflowDomain != 'default' or saveAll:
         cmds.addCommand( f"domain {ecoOptions.sflowDomain}" )

      # if samples table size and lifetime default: no samples command
      # if samples table size not-default but lifetime default:
      #     samples table size <size>
      # if samples lifetime not-default but table size default:
      #     samples lifetime <lifetime> seconds
      # if both not-default:
      #     samples table size <size> lifetime <lifetime> seconds
      tableSize = ""
      if ecoOptions.sflowFlowTableSize != 16384 or saveAll:
         tableSize = f" table size {ecoOptions.sflowFlowTableSize}"
      lifetime = ""
      if ecoOptions.sflowFlowLifetime != 300 or saveAll:
         lifetime = f" lifetime {ecoOptions.sflowFlowLifetime} seconds"
      if tableSize or lifetime:
         cmds.addCommand( f"samples{tableSize}{lifetime}" )
   elif saveAll:
      # we can do this because sflow has skipIfEmpty=False
      parentCmds.addCommand( "no provider sflow" )

   # provider isis
   mode = parentMode[ ProviderIsisSaveMode ].getSingletonInstance()
   cmds = mode[ "Mgmt.models.provider.isis" ]
   if octaConfig.isisOptions.linkStateDatabase:
      cmds.addCommand( "link-state-database" )
   elif saveAll:
      cmds.addCommand( "no link-state-database" )

   # provider ospf
   if RoutingLibToggle.toggleOspf2LsdbExportEnabled():
      mode = parentMode[ ProviderOspfSaveMode ].getSingletonInstance()
      cmds = mode[ "Mgmt.models.provider.ospf" ]
      for vrf in sorted( octaConfig.ospfOptions.linkStateDatabaseForVrf ):
         if vrf != DEFAULT_VRF:
            cmds.addCommand( f"link-state-database vrf {vrf}" )
         else:
            cmds.addCommand( "link-state-database" )
      # since saveAll won't remove link-state-database commands,
      # if no "provider ospf" mode will be printed, output "no provider ospf".
      # this won't work if there are other commands that might show up for saveAll.
      if ( cmds.empty( None ) and saveAll and
           not CliSave.hasComments( mode.commentKey(), requireMounts ) ):
         parentCmds.addCommand( "no provider ospf" )

   # provider configuration
   mode = parentMode[ ProviderConfigurationSaveMode ].getSingletonInstance()
   cmds = mode[ "Mgmt.models.provider.configuration" ]
   if gnmiConfig.saveSessionDiffs:
      cmds.addCommand( "updates" )
   elif saveAll:
      cmds.addCommand( "no updates" )
   if gnmiConfig.maxHistorySize != gnmiConfig.defaultMaxHistorySize or saveAll:
      cmds.addCommand( f"history limit {gnmiConfig.maxHistorySize}" )

   # provider models
   mode = parentMode[ ModelsSaveMode ].getSingletonInstance()
   cmds = mode[ "Mgmt.models.models" ]
   for path, available in octaConfig.yangPaths.items():
      if available:
         cmds.addCommand( f"path {path}" )
      else:
         cmds.addCommand( f"path {path} disabled" )

   # provider modules
   if OCToggle.toggleOCExclusiveModuleGroupSegmentationToggleEnabled():
      mode = parentMode[ ModulesSaveMode ].getSingletonInstance()
      cmds = mode[ "Mgmt.models.modules" ]
      for moduleGroup in octaConfig.exclusiveModuleGroups:
         cmds.addCommand( f"module group {moduleGroup} exclusive" )

   # provider macsec
   mode = parentMode[
      ProviderMacsecSaveMode ].getSingletonInstance()
   cmds = mode[ "Mgmt.models.provider.macsec" ]
   if macsecOptions.interfaces:
      cmds.addCommand( "interfaces" )
   elif saveAll:
      cmds.addCommand( "no interfaces" )
   if macsecOptions.mka:
      cmds.addCommand( "mka" )
   elif saveAll:
      cmds.addCommand( "no mka" )

   if OCToggle.toggleOCDefaultLeafsResponseToggleEnabled():
      if octaConfig.defaultLeafVisible:
         parentCmds.addCommand( "leaf default-value visible" )
      elif saveAll:
         parentCmds.addCommand( "no leaf default-value visible" )
