#!/usr/bin/env python3
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.Netconf import MgmtNetconfMode, NetconfTransportMode
from IpLibConsts import DEFAULT_VRF

class MgmtNetconfSaveMode( MgmtNetconfMode, CliSave.Mode ):
   def __init__( self, param ):
      MgmtNetconfMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

class NetconfTransportSaveMode( NetconfTransportMode, CliSave.Mode ):
   def __init__( self, param ):
      NetconfTransportMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( MgmtNetconfSaveMode )
MgmtNetconfSaveMode.addCommandSequence( "Mgmt.netconf" )

MgmtNetconfSaveMode.addChildMode( NetconfTransportSaveMode )
NetconfTransportSaveMode.addCommandSequence( 'Mgmt.netconf.transport' )

@CliSave.saver( "Netconf::Config", "mgmt/netconf/config" )
def saveNetconf( netconfConfig, root, requireMounts, options ):
   parentMode = root[ MgmtNetconfSaveMode ].getSingletonInstance()
   for name in netconfConfig.endpoints:
      mode = parentMode[ NetconfTransportSaveMode ].getOrCreateModeInstance( name )
      cmds = mode[ 'Mgmt.netconf.transport' ]
      endpoint = netconfConfig.endpoints[ name ]

      if not endpoint.enabled:
         cmds.addCommand( "shutdown" )
      elif options.saveAll:
         cmds.addCommand( "no shutdown" )

      if endpoint.port != endpoint.portDefault or options.saveAll:
         cmds.addCommand( "port %s" % endpoint.port )

      if endpoint.vrfName != DEFAULT_VRF or options.saveAll:
         cmds.addCommand( "vrf %s" % endpoint.vrfName )

