# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliMode.PhyTxEqProfilesMode import (
   ProfileMode, 
   ProfilesMode, 
   TapsMode 
)
from Plugins import SkipPluginModule
from Toggles import PhyEeeToggleLib
import CliSave

if not PhyEeeToggleLib.togglePhyTxEqProfilesConfigCliCmdEnabled():
   raise SkipPluginModule( 'Phy Tx Eq Profiles Config Toggle Not Enabled' )

class PhyTxEqProfilesConfigMode( ProfilesMode, CliSave.Mode ):
   def __init__( self, param ):
      ProfilesMode.__init__( self )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

CliSave.GlobalConfigMode.addChildMode( PhyTxEqProfilesConfigMode )
PhyTxEqProfilesConfigMode.addCommandSequence( 'PhyTxEqProfiles.config' )

class PhyTxEqProfileMode( ProfileMode, CliSave.Mode ):
   def __init__( self, param ):
      ProfileMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

PhyTxEqProfilesConfigMode.addChildMode( PhyTxEqProfileMode )
PhyTxEqProfileMode.addCommandSequence( 'PhyTxEqProfiles.config.profile' )

class PhyTxEqProfileTapsMode( TapsMode, CliSave.Mode ):
   def __init__( self, param ):
      TapsMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

PhyTxEqProfileMode.addChildMode( PhyTxEqProfileTapsMode )
PhyTxEqProfileTapsMode.addCommandSequence( 'PhyTxEqProfiles.config.profile.taps' )

@CliSave.saver( 'Hardware::Phy::PhyTxEqProfiles', 
                'hardware/archer/phy/config/cli/phyTxEqProfiles' )
def savePhyTxEqProfiles( entity, root, requireMounts, options ):
   profilesMode = root[ PhyTxEqProfilesConfigMode ].getSingletonInstance()
   for profileName, profile in entity.customProfiles.items(): # add new profile
      profileMode = profilesMode[ PhyTxEqProfileMode ].getOrCreateModeInstance( 
                                                                        profileName )
      if not profile.customTxTaps:
         continue
      tapMode = profileMode[ PhyTxEqProfileTapsMode ].\
            getOrCreateModeInstance( profileName )
      tapsCmds = tapMode[ 'PhyTxEqProfiles.config.profile.taps' ]
      for tapName, tap in profile.customTxTaps.items(): # add new tap
         tapsCmds.addCommand( f"{tapName} {tap.value}" )
