# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliSave

DEFAULT_LOW_VOLTAGE_WARNING_THRESHOLD = 0
DEFAULT_HIGH_VOLTAGE_WARNING_THRESHOLD = Tac.Value( "Units::Volts" ).value
DEFAULT_MAX_FAULT = 10

CliSave.GlobalConfigMode.addCommandSequence( 'Pmbus.config' )

@CliSave.saver( 'Hardware::PowerSupply::Pmbus::WarningCliConfig',
                'hardware/powerSupply/cli/warning',
                requireMounts=( 'hardware/powerSupply/slot/config', ) )
def savePowerSupplyLowVoltageWarning( entity, root, requireMounts, options ):
   cmds = root[ 'Pmbus.config' ]

   slotConfig = requireMounts[ 'hardware/powerSupply/slot/config' ]

   for slot in sorted( slotConfig.slotConfig.keys(), key=int ):
      slotId = int( slot )
      if slotId in entity.warningPmbusCliConfig:
         warningUnderThreshold = entity.warningPmbusCliConfig[ slotId ].\
                                 inputUnderVoltageWarningThreshold
         maxUnderFaultCount = entity.warningPmbusCliConfig[ slotId ].\
                              maxConsecutiveUnderVinFaults

         warningOverThreshold = entity.warningPmbusCliConfig[ slotId ].\
                                inputOverVoltageWarningThreshold
         maxOverFaultCount = entity.warningPmbusCliConfig[ slotId ].\
                             maxConsecutiveOverVinFaults
      else:
         warningUnderThreshold = DEFAULT_LOW_VOLTAGE_WARNING_THRESHOLD
         maxUnderFaultCount = DEFAULT_MAX_FAULT

         warningOverThreshold = DEFAULT_HIGH_VOLTAGE_WARNING_THRESHOLD
         maxOverFaultCount = DEFAULT_MAX_FAULT

      if ( warningUnderThreshold != DEFAULT_LOW_VOLTAGE_WARNING_THRESHOLD or
           maxUnderFaultCount != DEFAULT_MAX_FAULT or options.saveAll ):
         # pylint: disable-next=consider-using-f-string
         powerSupplyName = "PowerSupply%s" % slotId
         # pylint: disable-next=consider-using-f-string
         cmds.addCommand( 'power %s input voltage warning low %.2f readings %d' %
                          ( powerSupplyName, warningUnderThreshold,
                            maxUnderFaultCount ) )

      if ( warningOverThreshold != DEFAULT_HIGH_VOLTAGE_WARNING_THRESHOLD or
           maxOverFaultCount != DEFAULT_MAX_FAULT or options.saveAll ):
         # pylint: disable-next=consider-using-f-string
         powerSupplyName = "PowerSupply%s" % slotId
         # pylint: disable-next=consider-using-f-string
         cmds.addCommand( 'power %s input voltage warning high %.2f readings %d' %
                          ( powerSupplyName, warningOverThreshold,
                            maxOverFaultCount ) )
